/*
  Lécu Régis
  12/07/2016
 Trame à compléter sur les attaques par injection SQL
 */
package outils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LivreManager {

    // Ajout d'un livre 
    // le titre et le resumé ne sont pas filtrés et peuvent contenir du Java Script
    public static boolean ajouter(Connection co, String titre, String resume) {
        boolean ok = false;
        String req = "insert into Livre values (?, ?)";
        try {
            PreparedStatement pstmt = co.prepareStatement(req);
            pstmt.setString(1, titre);
            pstmt.setString(2, resume);

            int nb = pstmt.executeUpdate();
            ok = (nb == 1);
        } catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
            ok = false;
        }
        return ok;
    }

    public static List<String> lister(Connection co) {
        String req = "select * from Livre";
        List<String> liste = null;
        try 
        {
            Statement st = co.createStatement();
            ResultSet rs = st.executeQuery(req);
            if (rs != null) 
            {
                liste = new ArrayList<String>();
                while (rs.next())
                {
                    liste.add(rs.getString(1) + ":" + rs.getString(2));
                }
            }
        } 
        catch (SQLException ex) 
        {
            System.out.println(ex.getMessage());
            liste = null;
        }
        return liste;
    }
}
