/*
  Lécu Régis
  12/07/2016
 Trame à compléter sur les attaques par injection SQL
 */
package outils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmploiManager {

    // cette méthode privée récupère le numéro du dernier emploi crée 
    // (pour test sur Derby, sur SQL server prendre une clée auto-incrémentée)
    private static int getIdEmploi (Connection co)
    {            
        int idEmploi=0;
        String req = "select max(idEmploi) from Emplois";
        try
        {
            Statement st = co.createStatement();
            ResultSet rs =  st.executeQuery(req);
            if (rs.next())
            {
                idEmploi = rs.getInt(1) + 1;
            }          
        } 
        catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
            idEmploi = -1;
        }
        return idEmploi;
    }
    // Ajout d'un nouvel Emploi 
    // la description de l'emploi n'est pas filtrée et et peut contenir du Java Script
    public static boolean ajouter(Connection co, String description)
    {
        boolean ok = false;
        String req = "insert into Emplois values (?, ?)";
        try
        {            
            PreparedStatement pstmt = co.prepareStatement(req);
            int idNouveau = getIdEmploi(co) + 1;
            pstmt.setInt (1, idNouveau);
            pstmt.setString(2, description);

            int nb = pstmt.executeUpdate();
            ok = (nb == 1);
        } catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
            ok = false;
        }
        return ok;
    }

    // Lister les descriptions des emplois existants
    public static List<String> lister(Connection co) {
        String req = "select description from Emplois";
        List<String> liste = null;
        try 
        {
            Statement st = co.createStatement();
            ResultSet rs = st.executeQuery(req);
            if (rs != null) 
            {
                liste = new ArrayList<String>();
                while (rs.next())
                {
                    liste.add(rs.getString(1));
                }
            }
        } 
        catch (SQLException ex) 
        {
            System.out.println(ex.getMessage());
            liste = null;
        }
        return liste;
    }
}
