/*
Régis Lécu
26/07/2016

Chiffrement et déchiffrement d'un message par l'algorithme RSA
*/
package crypto;

import java.security.*;
import javax.crypto.*;

public class TestChiffrementRSA {

    // la méthode autoriteCertification retourne une paire de clés publique/privé
    //   générée en utilisant l'algorithme "RSA"
    public static KeyPair autoriteCertification() {
        KeyPair cles = null;
        try {
            // crée un générateur de paires de clés publiques/privées pour RSA
            KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
            // initialisation du générateur de paires de clés avec la taille de la clé en bits et une source d'aléa
            gen.initialize(2048, new SecureRandom());
            // création de la paire de clés
            cles = gen.generateKeyPair();
        } catch (NoSuchAlgorithmException ex) {
            System.out.println(ex);
        }
        return cles;
    }

    public static byte[] chiffrer (String text, PublicKey clePublique) 
    {
        byte[] texteChiffré = null;
        try 
        {
            // récupère un object de chiffrement avec l'algorithme RSA
            final Cipher cipher = Cipher.getInstance("RSA");
            // chiffre le texte en utilisant la clé publique
            cipher.init(Cipher.ENCRYPT_MODE, clePublique);
            texteChiffré = cipher.doFinal(text.getBytes());
        } 
        catch (Exception e) 
        {
            System.out.println(e);
        }
        return texteChiffré;
    }
    
    public static byte[] dechiffrer (byte[] texteChiffré, PrivateKey clePrivee) 
    {
        byte[] texteClair = null;
        try 
        {
            // récupère un object de chiffrement avec l'algorithme RSA
            final Cipher cipher = Cipher.getInstance("RSA");
            // déchiffre le texte en utilisant la clé privée
            cipher.init(Cipher.DECRYPT_MODE, clePrivee);
            texteClair = cipher.doFinal(texteChiffré);
        } 
        catch (NoSuchAlgorithmException | NoSuchPaddingException | InvalidKeyException | IllegalBlockSizeException | BadPaddingException e) 
        {
            System.out.println(e);
        }
        return texteClair;
    }
    public static void main(String[] args) {
        System.out.println("=== Chiffrement et déchiffrement d'un message avec RSA ===");
        try {
            String message = "Bonjour Régis. Le chat mange la souris.";
            KeyPair cles = autoriteCertification();
            
            // 1) chiffrement avec l'algorithme RSA avec la clé publique
            byte texteChiffre [] = chiffrer (message, cles.getPublic());
            System.out.println("TEXTE CHIFFRE =\n" + Tools.toStringHex(texteChiffre) );
           
            // 2) déchiffrement correct d'un message chiffré non altérée avec la clé privée.
            byte texteClair [] = dechiffrer(texteChiffre, cles.getPrivate());
            System.out.println("TEXTE DECHIFFRE =\n" + new String (texteClair) );          
            
            // 3) altération du message chiffré
            byte badmessage [] = texteChiffre.clone();
            badmessage[0] =  0;
            texteClair  = dechiffrer(badmessage, cles.getPrivate());
            
            // 3) clé privée erronée
            KeyPair badcles = autoriteCertification();
            texteClair  = dechiffrer(texteChiffre, badcles.getPrivate());
          
        } catch (Exception ex) {
            System.out.println(ex);
        }
    }

}
