package crypto;
/*
Régis Lécu 26/07/2016
Repris  de JM Doudoux

Utilisez en java un Certificat décrit par son fichier .cer
La séance décrit la création d'un certificat autosigné
avec la commande keytool 

 */

import java.io.FileInputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;

public class TestCertificats
{
  public static void main(String[] args)
  {
    try 
    {
      // création d'une fabrique de certificats au format X.509
      CertificateFactory cf = CertificateFactory.getInstance("X.509");
      // récupération d'un certificat autosigné 
      FileInputStream in = new FileInputStream("c:/test/moncertificat.cer");
      // création du certificat en Java (il contient la clé publique pour déchiffrer 
      //   informations )
      Certificate cert = cf.generateCertificate(in);
      System.out.println(cert);
      
      // ajout dans la liste de certificats du clients
      List<Certificate> listeCert = new ArrayList<Certificate>();
      listeCert.add(cert);

      CertPath cp = cf.generateCertPath(listeCert);
      System.out.println("\n Liste des certificats " );
      System.out.println (cp);
    } 
    catch (Exception e) 
    {
      e.printStackTrace();
    }
  }
}