/*
Régis Lécu
20/07/2016

Chiffrement et déchiffrement d'un message par l'algorithme symétrique AES
Merci à Jean-Michel Doudoux pour son exemple et ses explications : 
http://www.jmdoudoux.fr/java/dej/chap-jca.htm
 */
package crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class TestChiffrementAES 
{
    public static byte[] chiffrer(String texte, SecretKey secret) 
    {
        byte[] texteChiffré = null;
        try
        {
            // récupère un object de chiffrement avec l'algorithme AES
            Cipher cipher = Cipher.getInstance("AES");

            // chiffre le texte en utilisant la clé secrète (symétrique)
            cipher.init(Cipher.ENCRYPT_MODE, secret);
            texteChiffré = cipher.doFinal(texte.getBytes());            
        } 
        catch (Exception e) 
        {
            System.out.println(e);
        }
        return texteChiffré;
    }

    public static byte[] dechiffrer(byte[] texteChiffré, SecretKey secret) 
    {
        byte[] texteClair = null;
        try 
        {
            // récupère un object de chiffrement avec l'algorithme AES
            Cipher cipher = Cipher.getInstance("AES");
            // déchiffre le texte en utilisant la clé privée
            cipher.init(Cipher.DECRYPT_MODE, secret);
            texteClair = cipher.doFinal(texteChiffré);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return texteClair;
    }

    public static void main(String[] args)
    {

        try 
        {
            // 1) génération d'une clé privée de 128 bits pour l'algoritme symétrique AES
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(128);
            SecretKey cleSecrete = keyGen.generateKey();

            // Cette clé est utilisée par l'émetteur pour chiffrer son message avec AES
            byte[] texteChiffre = chiffrer ("Bonjour Régis. Le chat mange la souris", cleSecrete);
            System.out.println(Tools.toStringHex(texteChiffre));

            // 2) AES est un algorithme SYMETRIQUE : donc la même clé est ensuite utilisée pour
            // déchiffrer le texte
            byte [] texteClair = dechiffrer(texteChiffre, cleSecrete);
            System.out.println("Texte déchiffré : " + new String(texteClair));
            
            // 3) Pas de contrôle sur l'altération du texte (attaque Man in the Middle jouant sur l'intégrité du message
            byte badtexte [] = texteChiffre.clone();
            badtexte[0] = 0;
            texteClair = null;
            // il n'y a pas d'exception : le message altéré est déchiffré
            texteClair = dechiffrer(badtexte, cleSecrete);
            System.out.println("Texte déchiffré : " + new String(texteClair));
            
            // 4) Tentative de déchiffrement avec une clé privée incorrecte
            // Il y a une exception "BadPaddingException : Given final block not properly padded"
            texteClair = dechiffrer(texteChiffre, keyGen.generateKey());                      
        } 
        catch (Exception e)
        {
            System.out.println("Erreur " + e);
        }
    }
}
