/*
  Lécu Régis
  25/08/2016
 Démo sur les injections SQL : proposition de corrigé
testé sur la base de données DERBY Java
*/
package demoinjectionsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import outils.Authentification;
import outils.ConnexionBdd;


public class DemoInjectionSQL
{   
    public static void main(String[] args) 
    {
        Connection co = ConnexionBdd.getInstance().ouvrir();
        // 1) version non sécurisée : 
        // faire plusieurs essais fonctionnels et préparer un jeu d'essai malveillant, en testant plusieurs syntaxes d'injection SQL
        System.out.println("Version non sécurisée : démo injection SQL");
        String user = "lecu";
        String pwd = "regis"; 
       
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExist(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        user = "lecux";
        pwd ="regis";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExist(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        user = "xx";
        pwd = "zz' or '1'='1";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExist(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
                    
        user = "xx";
        pwd = "zz' or 1=1 --";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExist(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        // ne marche pas car l'analyseur syntaxique de JDBC détecte une chaîne non terminée et le EOF
        
        user = "xx";
        pwd = "zz' or 1=1 -- '";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        // marche en rajoutant la fin de chaine dans le commentaire
        if (Authentification.userExist(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        
        // 2) version sécurisée : refaire tout le jeu d'essai, y compris le malveillant        
        System.out.println("Les mêmes tests unitaires en version sécurisée");
        user = "lecu";
        pwd = "regis"; 
       
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        user = "lecux";
        pwd ="regis";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        user = "xx";
        pwd = "zz' or '1'='1";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        
        user = "xx";
        pwd = "zz' or '1'='1";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
               
        user = "xx";
        pwd = "zz' or 1=1 --";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");
        // ne marche pas car l'analyseur syntaxique de JDBC détecte une chaîne non terminée et le EOF
        
        user = "xx";
        pwd = "zz' or 1=1 -- '";
        System.out.println("Test de user =" + user + "  pwd =" + pwd);
        // marche en rajoutant la fin de chaine dans le commentaire
        if (Authentification.userExistV2(co, user, pwd) ) 
            System.out.println("=> reconnu");
        else
            System.out.println("=>inconnu");      
    }

}
