/*
  Lécu Régis
  12/07/2016
 Trame à compléter sur les attaques par injection SQL
*/
package demoinjectionsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;


public class DemoInjectionSQL
{
    // Version vulnérable aux injections
    public static boolean userExist(Connection con, String nom, String motpasse) {
        boolean existe = false;
        String req = "select count(*) from user where name='" + nom + "' and mdp='" + motpasse + "'";
        System.out.println(req);
        try {
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(req);
            if (rs.next()) {
                if (rs.getInt(1) != 0) {
                    existe = true;
                }
            }
        } catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
        }
        return existe;
    }

    // version sécurisée : par requête paramétrée
    public static boolean userExistV2(Connection con, String nom, String motpasse) {
        // TODO : tester la connexion et valider nom et motpasse
        //  par des expressions régulières

        boolean existe = false;
        // le texte de la requête paramétrée ne contient que du SQL sûr
        // les emplacements des paramètres sont marqués par des points d’interrogation
        String req = "select count(*) from user where name=? and mdp=?";
        System.out.println(req);
        try
        {
            // on crée la requête paramétrée à partir d’une connexion existante
            PreparedStatement pstmt = con.prepareStatement(req);

            // on donne les valeurs des paramètres à la requête
            pstmt.setString(1, nom);
            pstmt.setString(2, motpasse);

            // appel de la requête paramétrée 
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                // on code EXACTEMENT la fonctionnalité demandée
                // (en supposant l’unicité du nom) 	
                if (rs.getInt(1) == 1) {
                    existe = true;
                }
            }
        } catch (SQLException e) {
            System.out.println("Exception : " + e.getMessage());
        }
        return existe;
    }

    public static void main(String[] args) 
    {
        // TODO: créer ici et ouvrir la connexion vers votre SGDB SQL Server
        Connection co = null;
        // 1) version non sécurisée : 
        // faire plusieurs essais fonctionnels et préparer un jeu d'essai malveillant, en testant plusieurs syntaxes d'injection SQL
        userExist(co, "lecu", "regis' or '1'='1");
        // Pour le moment, l'appel s'arrête forcément en NullPointerException
        
        // 2) version sécurisée : refaire tout le jeu d'essai, y compris le malveillant        
        userExistV2(co, "lecu", "regis' or '1'='1");
        
        // 3) appeler ici votre procédure stockée : refaire tout le jeu d'essai, y compris le malveillant   
        // TODO
        
    }

}
