/*
Régis Lécu, 21/06/2016

   Exemple fourni par l'ANSSI sur l'introspection (package reflect) en Java
   La notion d'encapsulation est très utile, en génie logiciel, pour gérer l'abstraction des
   classes et améliorer la qualité du code.
MAIS : c'est une convention "de bonne conduite" entre l'appelant et la classe, qui peut
être changé à la demande en utilisant l'introspection. Comme son nom l'indique,
cette méthode permet d'interroger la classe, d'obtenir la liste de ses méthodes, de ses attributs,
et de changer leur niveau d'accessibilité !
 */
package demointrospection;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

class Secret 
{
    // x = champ à publier
    private int x = 42;
    // y = champ que l'on veut cacher !
    private int y = 1515;

    // la méthode badGet utilise la reflection Java de façon maladroite et casse
    //  l'encapsulation du champ y
    public int badGet(String nom) 
    {
        int retour = -1;
        try
        {
            Field f = this.getClass().getDeclaredField(nom);
            retour = f.getInt(this);
        }
        catch (Exception ex)
        {
            System.out.println(ex);          
        }        
        return retour;
    }
}

public class IntrospectSec {

    public static void main(String[] args) {
        System.setSecurityManager(new SecurityManager());
        // 1) la tentative directe est stopppée par le Security Manager standard
        System.out.println("Avec un security manager, on ne peut plus modifier ");
        System.out.println("l'accessibilite");
        try {
            Secret o = new Secret();
            Class c = o.getClass();
            Field f = c.getDeclaredField("x");
            f.setAccessible(true);
            System.out.println("x=" + f.getInt(o));

            // compléments AFPA
            Secret o2 = new Secret();
            System.out.println("x=" + f.getInt(o2));

            f.setAccessible(false);
            System.out.println("x=" + f.getInt(o));

        } 
        catch (Exception e) {
            System.out.println(e);
        }
        
        // 2) vulnérabilité restante : créee par une maladresse du développeur
        System.out.println("Mais on peut encore casser l'encapsulation en utilisant mal la reflection");
        Secret o3 = new Secret();
        System.out.println("x = " + o3.badGet("x") );
        System.out.println("y = " + o3.badGet("y") );
     
    }
}
