/*
   Exemple fourni par l'ANSSI sur l'introspection (package reflect) en Java
   La notion d'encapsulation est très utile, en génie logiciel, pour gérer l'abstraction des
   classes et améliorer la qualité du code.
MAIS : c'est une convention "de bonne conduite" entre l'appelant et la classe, qui peut
être changé à la demande en utilisant l'introspection. Comme son nom l'indique,
cette méthode permet d'interroger la classe, d'obtenir la liste de ses méthodes, de ses attributs,
et de changer leur niveau d'accessibilité !
*/
package demointrospection;

import java.lang.reflect.Field;

    class Secret
    {
        private int x = 42;
    }

  public class Introspect
   {
    public static void main(String[] args) 
    {
        try 
        {           
            Secret o = new Secret();
            Class c = o.getClass();
            Field f = c.getDeclaredField("x");
            f.setAccessible(true);
            System.out.println("x=" + f.getInt(o));
           
            // compléments AFPA
            Secret o2 = new Secret();
            System.out.println("x=" + f.getInt(o2));
            
            f.setAccessible(false);
            System.out.println("x=" + f.getInt(o));
        } 
        catch (Exception e) 
        {
            System.out.println(e);
        }
     }
}
