package normalizestrings;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/* Lécu Régis, 22/06/2016
Démonstration selon la fiche du CERT des problèmes causés par les caractère UTF-8
dans une chaîne JAVA 
et solution, en normalisant la chaine au format NFKC
*/
public class NormalizeStrings {

    public static void main(String[] args) {
        // La chaîne s doit pouvoir être contrôlée (Minimiser sa confiance !)
        // \uFE64 se normalise en < et \uFE65 en > en utilisant la normalisation NFKC
        String s = "\uFE64" + "script" + "\uFE65";
        
        // La chaine est affichée normalement
        System.out.println("Votre saisie est :" + s);
        // Le caractère fautif également
        System.out.println ("Elle commence par : " + s.charAt(0));
        
        // Mais ce caractère n'est pas celui qu'on croit !
        if (s.charAt(0) == '<' )
           System.out.println("Chaine refusée : commence par < ");
        else
           System.out.println("Debut de chaine OK");
        
        // Validation d'une chaine non normalisée :        
        // on recherche les crochets ouvrant et fermant par une expression régulière
        // Technique de liste noire, pas de liste blanche (conseillée quand on peut)
        Pattern pattern = Pattern.compile("[<>]"); // Check for angle brackets
        Matcher matcher = pattern.matcher(s);
        if (matcher.find()) 
        {
            // on a trouvé un TAG de la liste noire
            // on lance une exception
            throw new IllegalStateException();
        }
        else 
        {
            System.out.println("Tout va bien : la chaine ne comporte ni < ni >");
        }

        // Normalisation en NFKC
        s = Normalizer.normalize(s, Normalizer.Form.NFKC);
        if (s.charAt(0) == '<' )
           System.out.println("APRES NORMALISATION : Chaine refusée : commence par < ");
        else
           System.out.println("Debut de chaine OK");
        
        // Validation de la chaine après sa normalisation
        matcher = pattern.matcher(s);
        if (matcher.find()) 
        {
           // on a trouvé un TAG de la liste noire
            // on lance une exception
            throw new IllegalStateException();
        }
        else 
        {
            System.out.println("Tout va bien : la chaine ne comporte ni < ni >");
        }
    }
}
