/* Corruption de la Pile Systme suite  un Buffer Overflow
(Exemple fourni par l'ANSSI)
avec dtournement vers une fonction prexistante (sans injection de code)

Ce programme provoque un Stack Overflow qui crase l'adresse de retour dans la fonction SET
en lui substituant l'adresse de la fonction BAD.
Il s'agit ici d'un BUG (qui cre une vulnrabilit et pourrait tre exploit dans une attaque)

Compilez ce programme en mode release et en mode debug. Obervez les diffrences
Faire le tourner sans et sous debugger
*/
#include <stdio.h>
#include <stdlib.h>

/* A l'appel de la fonction SET, le main empile les paramtres dans l'ordre inverse : d'abord v, puis s
 puis il empile l'adresse de retour (adresse du printf ("hello word") dans le main)
 Cette fonction bugue crase l'adresse de retour, en la remplaant par l'adresse de la fonction BAD.

 Dtaillons :
-   &s pointe sur le paramtre s dans la Pile, donc l'adresse immdiatement aprs l'adresse de retour
-   le paramtre s vaut 1 (dans le cas du bug) donc &s-s vaut &s-1
-   &s-1 pointe donc sur l'adresse de retour (attention : -1 dcrmente l'adresse de 4 octets car c'est un pointeur d'int)
-   le paramtre v de type int contient en ralit l'adresse de la fonction BAD 
(grce au CAST dans l'appel de la fonction set dans le main : set (1, (int) bad);
*/
void set(int s, int v)
{ 	
	*(&s - s) = v; 
}

void bad()
{ 
	printf("Bad things happen!\n");
	exit(0);
}

int main(void)
{
	set(1, (int)bad); 
	printf("Hello world\n"); 
	return 0;
}
