/* Programme C de dmonstration du "buffer overflow" (1) :
Lcu Rgis, 06/06/2016

Points  noter :
- les tableaux PRENOM et TABBUG sont dclars dans une fonction,
donc ils sont dans la PILE
- le tableau TABBUG est dclar aprs PRENOM. Comme la pile "remonte"
vers les adresses basses, TABBUG est donc plac en mmoire avant PRENOM
- en dpassant la limite du tableau TABBUG, la boucle crase donc le
dbut du tableau PRENOM
- on constate que le C ne fait aucune vrification mmoire sur les tableaux
et que le buffer overflow n'est pas dtect

La suite de l'exemple teste des buffers overflows avec des variables statiques,
et sur des variables alloues dynamiquement dans le HEAP (tas)
*/
#include <stdio.h>
#include <stdlib.h>
// variables "statiques" : ont une adresse fixe, une dure de vie pendant tout le programme,
//   et elles sont dans l'ordre de leur dclaration en mmoire
static char tabbug2[4];
static char nom[8];

void main()
{
	// variables locales de la fonction main en Pile : en mmoire, TABBUG prcde PRENOM
	char prenom[] = "regis";
	char tabbug[8];

	printf("********** Le Buffer Overflow en langage C ************\n\n");

	printf("(1) ---- Buffer Overflow en Pile -----\n");
	// (1) Buffer overflow dans la pile
	printf("********** Le Buffer Overflow en langage C ************\n");
	printf("TABBUG est a l'adresse:%p, de taille:%d\n", tabbug, sizeof(tabbug));
	printf("PRENOM est a l'adresse:%p, de taille:%d et contient au debut %s\n\n", prenom, sizeof(prenom), prenom);
	printf("Les deux variables sont distantes de %d octets en memoire", prenom-tabbug);

	int i;
	// On dpasse les limites du tableau TABBUG et on crase le dbut de PRENOM (buffer overflow dans la pile)	
	for (i = 0; i <= 16; i++)
	{
		tabbug[i] = '#';
	}

	printf("\n\nApres le buffer overflow, PRENOM contient : %s\n", prenom);

	printf("\n(2) -- Buffer Overflow avec des variables statiques -----\n");
	// (2) Buffer overflow avec des variables statiques
	printf("TABBUG2 est a l'adresse:%p, de taille:%d\n", tabbug2, sizeof(tabbug2));
	printf("NOM est a l'adresse:%p, de taille:%d\n", nom, sizeof(nom));
	
	printf("Les deux variables sont distantes de %d octets en memoire", nom - tabbug2);

	// initialisation (correcte) du tableau NOM
	for (i = 0; i < 7 ; i++)
	{
		nom[i] = 'a';
	}
	nom[i] = 0;   // les string C se terminent par un zro binaire
	printf("\nAu debut, NOM vaut: %s\n", nom);

	// On dpasse les limites du tableau TABBUG2 et on crase le dbut de NOM (buffer overflow dans la pile)	
	tabbug2[4] = '#';		// bug typique en C : confusion entre taille du tableau et dernier indice
	printf("\n\nApres le buffer overflow, PRENOM contient : %s\n", nom);

	printf("\n\n(3) ------- Plus sournois ! -\n");
	// Dans les deux premiers cas, il s'agissait de bugs purs et simples qu'il suffit de corriger
	// Dans ce troisime exemple, en utilisant mal la fonction SCANF, sans prciser la taille du tableau  saisir,
	// on donne la possibilit  l'utilisateur (ventuellement malveillant) de  provoquer volontairement l'crasement

	strcpy(nom, "aaaaaaa");  // rinialisation du tableau NOM (pour le test suivant)

	printf("%s", "Rentrer un texte (merci de saisir trois caracteres au plus) :");
	// vous entrerez d'abord moins de trois caractres, quatre, et plus de quatre 
	scanf("%s", tabbug2);
	printf("Apres le buffer overflow, NOM vaut:%s\n", nom);

	strcpy(nom, "aaaaaaa");  // rinialisation du tableau NOM (pour le test suivant)
	printf("%s", "Rentrer un texte (trois caracteres au plus, pas le choix!) :");
	// Version en code scuris : on utilise toujours un format indiquant la taille maximale  saisir (-1 pour le zro terminateur)
	scanf("%3s", tabbug2);
	printf("Apres le buffer overflow, NOM vaudra toujours :%s\n", nom);

	printf("\n\n(4) ---- Buffer Overflow dans le HEAP -----\n");
	char * p1 = (char *)malloc(8);
	char * p2 = (char *)malloc(8);
	// les pointeurs p1 et p2 (comme des rfrences en langage Java) reoivent les adresses des deux blocs mmoire allous dans le Heap
	printf("Le pointeur p1 vaut %x, p2 vaut %x\n", (int)p1, (int)p2);
	printf("Les deux blocs memoire sont distants de %d\n", (int)p2-(int)p1);
	// les zones pointes peuvent tre considres comme des tableaux dynamiques (notation avec [] )
	strcpy(p2, "regis");

	printf("A depart, p2 pointe sur:%s\n", (char *)p2);
	int offset = ((int)p2 - (int)p1);
	p1 [offset] = '#';
	printf("%s", p2);

	printf("\nApres le buffer overflow, p2 pointe sur:%s\n", (char *)p2);

}