/*
   Client SSL : 
   Lcu Rgis 11/10/2016
   
   Programme de dmonstration de liaison SSL :
   ce client saisit des chaines au clavier et les envoie au serveur
*/
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import java.io.*;

public class ClientSSL 
{
	private static final int NPORT = 9000; // numro de port IP du socket SSL
    public static void main(String[] args) 
	{
        try 
		{
			System.out.println ("=== Demo client SSL ====");
			// 1 rcupration de la factory de sockets par dfaut
            SSLSocketFactory sslSockFact = (SSLSocketFactory) SSLSocketFactory.getDefault();
			// 2 cration d'un socket (pour l'envoi des messages) sur la machine locale, port NPORT
            SSLSocket sslsocket = (SSLSocket) sslSockFact.createSocket("localhost", NPORT);

			// 3 lecture bufferise clavier
            InputStreamReader reader = new InputStreamReader(System.in);
            BufferedReader buffreader = new BufferedReader(reader);

			// 4 criture bufferise sur le socket SSL
            OutputStream outstream = sslsocket.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(outstream);
            BufferedWriter buffwriter = new BufferedWriter(writer);

			// 5 cho de la saisie clavier vers le socket SSL
			System.out.println ("Votre message :");
            String s = buffreader.readLine();
            while ( (s != null) && !s.equals("") )
			{				
                buffwriter.write(s + '\n');
				buffwriter.flush();
				System.out.println ("Votre message :");
                s = buffreader.readLine();
            }
		    System.out.println ("===== FIN EMISSION ====");
        } 
		catch (Exception exception) 
		{
            exception.printStackTrace();
        }
    }
}
