/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.splitbysize;

import org.pdfsam.i18n.I18nContext;

public enum SizeUnit {
    MEGABYTE(I18nContext.i18n().tr("Megabytes"), I18nContext.i18n().tr("MB")){

        @Override
        public long toBytes(int raw) {
            return KILOBYTE.toBytes(raw) * 1024L;
        }
    }
    ,
    KILOBYTE(I18nContext.i18n().tr("Kilobytes"), I18nContext.i18n().tr("KB")){

        @Override
        public long toBytes(int raw) {
            return (long)raw * 1024L;
        }
    };

    private final String name;
    private final String symbol;

    private SizeUnit(String name, String symbol) {
        this.name = name;
        this.symbol = symbol;
    }

    public String friendlyName() {
        return this.name;
    }

    public String symbol() {
        return this.symbol;
    }

    public abstract long toBytes(int var1);
}

