/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.support.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.core.support.validation.ContainedIntegerValidator;
import org.pdfsam.core.support.validation.FileTypeValidator;
import org.pdfsam.core.support.validation.FileValidator;
import org.pdfsam.core.support.validation.PositiveIntRangeStringValidator;
import org.pdfsam.core.support.validation.PositiveIntegerStringValidator;
import org.pdfsam.core.support.validation.RegexValidator;
import org.pdfsam.core.support.validation.Validator;
import org.pdfsam.model.io.FileType;

public final class Validators {
    private Validators() {
    }

    public static Validator<String> alwaysFalse() {
        return v -> false;
    }

    public static Validator<String> nonBlank() {
        return StringUtils::isNotBlank;
    }

    public static Validator<String> positiveInteger() {
        return new PositiveIntegerStringValidator();
    }

    public static Validator<String> positiveIntRange(int lower, int upper) {
        return new PositiveIntRangeStringValidator(lower, upper);
    }

    public static Validator<String> containedInteger(Set<Integer> validValues) {
        return new ContainedIntegerValidator(validValues);
    }

    public static Validator<String> existingFile() {
        return new FileValidator();
    }

    public static Validator<String> existingFileType(FileType type) {
        return new FileTypeValidator(type, true);
    }

    public static Validator<String> fileType(FileType type, boolean mustExist) {
        return new FileTypeValidator(type, mustExist);
    }

    public static Validator<String> existingDirectory() {
        return v -> StringUtils.isNotBlank((CharSequence)v) && Files.isDirectory(Paths.get(v, new String[0]), new LinkOption[0]);
    }

    public static Validator<String> regexMatching(String regex) {
        return new RegexValidator(regex);
    }

    public static Validator<String> validEmpty(Validator<String> validator) {
        return v -> {
            if (StringUtils.isNotEmpty((CharSequence)v)) {
                return validator.isValid((String)v);
            }
            return true;
        };
    }

    public static Validator<String> not(Validator<String> validator) {
        return v -> !validator.isValid((String)v);
    }

    public static Validator<String> and(Validator<String> ... validators) {
        return v -> Arrays.stream(validators).allMatch(validator -> validator.isValid(v));
    }
}

