/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.model.io.FileType;

public class FileChooserWithWorkingDirectory {
    private final FileChooser wrapped = new FileChooser();

    FileChooserWithWorkingDirectory() {
        ApplicationContext.app().runtimeState().workingPath().subscribe(p -> this.wrapped.setInitialDirectory((File)p.map(Path::toFile).orElse(null)));
    }

    final void setTitle(String value) {
        this.wrapped.setTitle(value);
    }

    public final void setInitialFileName(String value) {
        this.wrapped.setInitialFileName(value);
    }

    public final void setInitialDirectory(Path value) {
        this.wrapped.setInitialDirectory((File)Optional.ofNullable(value).map(Path::toFile).orElse(null));
    }

    private void sanitizeInitialDirectory() {
        if (Optional.ofNullable(this.wrapped.getInitialDirectory()).map(File::toPath).filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).isPresent()) {
            this.wrapped.setInitialDirectory(null);
        }
    }

    public List<Path> showOpenMultipleDialog(Window ownerWindow) {
        this.sanitizeInitialDirectory();
        List<Path> selected = Optional.ofNullable(this.wrapped.showOpenMultipleDialog(ownerWindow)).stream().flatMap(Collection::stream).map(File::toPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
        if (!selected.isEmpty()) {
            this.updateWorkingPath(selected.get(0));
        }
        return selected;
    }

    void setFileTypes(FileType ... filters) {
        this.wrapped.getExtensionFilters().setAll(Arrays.stream(filters).map(FileType::getFilter).toList());
    }

    private Path updateWorkingPath(Path path) {
        if (Objects.nonNull(path)) {
            ApplicationContext.app().runtimeState().maybeWorkingPath(path);
        }
        return path;
    }

    private Path singleFileDialog(File file) {
        return Optional.ofNullable(file).map(File::toPath).filter(f -> !Files.isDirectory(f, new LinkOption[0])).map(this::updateWorkingPath).orElse(null);
    }

    public Path showOpenSingleDialog(Window ownerWindow) {
        this.sanitizeInitialDirectory();
        return this.singleExistingFileDialog(this.wrapped.showOpenDialog(ownerWindow));
    }

    private Path singleExistingFileDialog(File file) {
        return Optional.ofNullable(file).map(File::toPath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(this::updateWorkingPath).orElse(null);
    }

    public Path showSaveDialog(Window ownerWindow) {
        this.sanitizeInitialDirectory();
        return this.singleFileDialog(this.wrapped.showSaveDialog(ownerWindow));
    }

    public List<Path> showOpenDialog(Window ownerWindow, boolean multiple) {
        if (!multiple) {
            return List.of(this.showOpenSingleDialog(ownerWindow));
        }
        return this.showOpenMultipleDialog(ownerWindow);
    }
}

