/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.context;

import java.util.function.Supplier;
import org.pdfsam.core.context.PersistentProperty;
import org.sejda.model.pdf.PdfVersion;

public enum StringPersistentProperty implements PersistentProperty<String>
{
    WORKSPACE_PATH(() -> ""),
    WORKING_PATH(() -> ""),
    STARTUP_MODULE(() -> ""),
    LOCALE(() -> System.getProperty("org.pdfsam.default.locale")),
    THEME(() -> System.getProperty("org.pdfsam.default.theme")),
    FONT_SIZE(() -> ""),
    PDF_VERSION(() -> {
        String version = System.getProperty("org.pdfsam.default.pdf.version", PdfVersion.VERSION_1_5.name());
        try {
            PdfVersion.valueOf((String)version);
            return version;
        }
        catch (IllegalArgumentException e) {
            return PdfVersion.VERSION_1_5.name();
        }
    }),
    PREFIX(() -> System.getProperty("org.pdfsam.default.prefix", "PDFsam_"));

    private final Supplier<String> defaultSupplier;

    private StringPersistentProperty(Supplier<String> supplier) {
        this.defaultSupplier = supplier;
    }

    @Override
    public String key() {
        return this.name().toLowerCase();
    }

    @Override
    public Supplier<String> defaultSupplier() {
        return this.defaultSupplier;
    }
}

