/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.core.context;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.theme.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRuntimeState {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationRuntimeState.class);
    private Path defaultWorkingPath;
    private final SimpleObjectProperty<Optional<Path>> workingPath = new SimpleObjectProperty(Optional.empty());
    private final SimpleObjectProperty<Optional<Tool>> activeTool = new SimpleObjectProperty(Optional.empty());
    private final SimpleObjectProperty<Theme> theme = new SimpleObjectProperty();
    private final Future<Map<String, Tool>> tools;

    ApplicationRuntimeState() {
        try (ExecutorService executor = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("tools-loader-", 0L).factory());){
            this.tools = executor.submit(() -> ServiceLoader.load(Tool.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toMap(Tool::id, Function.identity())));
        }
    }

    void workingPath(Path path) {
        this.workingPath.set(Optional.ofNullable(path).map(p -> {
            if (Files.isRegularFile(p, new LinkOption[0])) {
                return p.getParent();
            }
            return p;
        }).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])));
    }

    public void maybeWorkingPath(String path) {
        this.maybeWorkingPath((Path)Optional.ofNullable(path).filter(StringUtils::isNotBlank).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null));
    }

    public void maybeWorkingPath(Path path) {
        if (Objects.isNull(this.defaultWorkingPath)) {
            this.workingPath(path);
        }
    }

    public Optional<Path> workingPathValue() {
        return (Optional)this.workingPath.getValue();
    }

    public ObservableValue<Optional<Path>> workingPath() {
        return this.workingPath;
    }

    public Map<String, Tool> tools() {
        try {
            return this.tools.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Unable to load tools list", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public void activeTool(Tool activeTool) {
        this.activeTool.set(Optional.ofNullable(activeTool));
    }

    public Optional<Tool> activeToolValue() {
        return (Optional)this.activeTool.getValue();
    }

    public ObservableValue<Optional<Tool>> activeTool() {
        return this.activeTool;
    }

    public ObservableValue<Theme> theme() {
        return this.theme;
    }

    public void theme(Theme theme) {
        Optional.ofNullable(theme).ifPresent(arg_0 -> this.theme.set(arg_0));
    }

    void defaultWorkingPath(Path defaultWorkingPath) {
        this.defaultWorkingPath = defaultWorkingPath;
        this.workingPath(defaultWorkingPath);
    }
}

