/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AbstractPdfInputFilesSource;
import org.sejda.conversion.exception.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XmlFileSourceListParser
extends AbstractPdfInputFilesSource {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFileSourceListParser.class);
    private XPathFactory xpathFactory = XPathFactory.newInstance();

    XmlFileSourceListParser() {
    }

    @Override
    protected List<String> parseFileNames(File file) {
        try {
            return this.doParseFileNames(file);
        }
        catch (Exception e) {
            LOG.error("Can't extract filenames", (Throwable)e);
            throw new ConversionException("Can't extract filenames from '" + file.getName() + "'. Reason:" + e.getMessage(), e);
        }
    }

    protected List<String> doParseFileNames(File file) throws IOException, SAXException, ParserConfigurationException, XPathException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = domFactory.newDocumentBuilder();
        Document doc = builder.parse(file);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.parseSingleFiles(doc));
        result.addAll(this.parseFileSets(doc, file));
        return result;
    }

    private List<String> parseFileSets(Document doc, File configFile) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodeList = this.getNodeListMatchingXpath("//filelist/fileset/file", doc);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String filePath;
            Node node = nodeList.item(i);
            Node fileSet = node.getParentNode();
            String parentDirPath = XmlFileSourceListParser.nullSafeGetStringAttribute(fileSet, "dir");
            if (parentDirPath == null) {
                parentDirPath = configFile.getAbsoluteFile().getParent();
            }
            if (FilenameUtils.getPrefixLength((String)(filePath = this.extractFilePath(node))) > 0) {
                LOG.warn("File " + filePath + " in fileset " + (String)StringUtils.defaultIfBlank((CharSequence)XmlFileSourceListParser.nullSafeGetStringAttribute(fileSet, "dir"), (CharSequence)"") + " seems to be an absolute path. Will _not_ be resolved relative to the <fileset>, but as an absolute path. Normally you would want to use relative paths in a //filelist/fileset/file, and absolute paths in a //filelist/file.");
            }
            result.add(FilenameUtils.concat((String)parentDirPath, (String)filePath));
        }
        return result;
    }

    private String extractFilePath(Node fileNode) {
        String password = XmlFileSourceListParser.nullSafeGetStringAttribute(fileNode, "password");
        String value = XmlFileSourceListParser.nullSafeGetStringAttribute(fileNode, "value");
        return value + (String)(password == null ? "" : ":" + password);
    }

    private List<String> parseSingleFiles(Document doc) throws XPathExpressionException {
        ArrayList<String> result = new ArrayList<String>();
        NodeList nodeList = this.getNodeListMatchingXpath("//filelist/file", doc);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            result.add(this.extractFilePath(nodeList.item(i)));
        }
        return result;
    }

    private NodeList getNodeListMatchingXpath(String xpathString, Document doc) throws XPathExpressionException {
        return (NodeList)this.xpathFactory.newXPath().evaluate(xpathString, doc, XPathConstants.NODESET);
    }

    private static String nullSafeGetStringAttribute(Node node, String attributeName) {
        return Optional.ofNullable(node).map(Node::getAttributes).map(m -> m.getNamedItem(attributeName)).map(Node::getNodeValue).orElse(null);
    }
}

