/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.FriendlyNamed;
import org.sejda.model.exception.SejdaRuntimeException;

public final class EnumUtils {
    private EnumUtils() {
    }

    public static <T extends Enum<?>> T valueOfSilently(Class<T> enumClass, String displayName) {
        for (Enum each : (Enum[])enumClass.getEnumConstants()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)((FriendlyNamed)each).getFriendlyName(), (CharSequence)displayName)) continue;
            return (T)each;
        }
        return null;
    }

    public static <T extends Enum<?>> T valueOf(Class<T> enumClass, String displayName, String describedEnumClass) {
        T result = EnumUtils.valueOfSilently(enumClass, displayName);
        if (result == null) {
            throw new SejdaRuntimeException("Invalid value '" + displayName + "' for " + describedEnumClass + ". Valid values are '" + StringUtils.join(EnumUtils.findValidValues(enumClass), (String)"', '") + "'");
        }
        return result;
    }

    private static <T extends Enum<?>> Collection<String> findValidValues(Class<T> enumClass) {
        ArrayList<String> result = new ArrayList<String>();
        for (Enum each : (Enum[])enumClass.getEnumConstants()) {
            result.add(each.getFriendlyName());
        }
        Collections.sort(result);
        return result;
    }
}

