/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.awt.Dimension;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.AdapterUtils;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;

public class DimensionAdapter {
    private Dimension dimension = null;

    public DimensionAdapter(String rawString) {
        try {
            this.doParseInput(rawString);
        }
        catch (SejdaRuntimeException e) {
            throw new ConversionException("Could not parse input: '" + rawString + "'. " + e.getMessage(), e);
        }
    }

    private void doParseInput(String input) {
        String[] tokens = StringUtils.split((String)input, (String)"x");
        if (tokens.length != 2) {
            throw new ConversionException("Expected a string in the form \"WIDTHxHEIGHT\" but found '" + input + "'");
        }
        this.dimension = new Dimension(AdapterUtils.parseInt(tokens[0], "width"), AdapterUtils.parseInt(tokens[1], "height"));
    }

    public Dimension getDimension() {
        return this.dimension;
    }
}

