/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimization;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.impl.sambox.component.optimization.InUseDictionary;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDictionaryCleaner
implements Consumer<PDDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDictionaryCleaner.class);

    @Override
    public void accept(PDDocument p) {
        LOG.debug("Cleaning resource dictionaries from unused resources");
        this.clean(() -> p.getPages().streamNodes());
    }

    public void clean(PDPage page) {
        this.clean(() -> Stream.of(page.getCOSObject()));
    }

    private void clean(Supplier<Stream<COSDictionary>> nodes) {
        Supplier<Stream> resources = () -> ((Stream)nodes.get()).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull);
        this.cleanResources(resources.get().collect(Collectors.toSet()));
        Stream<COSDictionary> formsResources = resources.get().map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull).flatMap(d -> d.getValues().stream()).filter(d -> d.getCOSObject() instanceof COSDictionary).map(d -> (COSDictionary)d.getCOSObject()).filter(d -> COSName.FORM.equals((Object)d.getCOSName(COSName.SUBTYPE))).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull);
        Stream<COSDictionary> softmaskResources = resources.get().map(d -> (COSDictionary)d.getDictionaryObject(COSName.EXT_G_STATE, COSDictionary.class)).filter(Objects::nonNull).flatMap(d -> d.getValues().stream()).filter(d -> d.getCOSObject() instanceof COSDictionary).map(d -> (COSDictionary)((COSDictionary)d.getCOSObject()).getDictionaryObject(COSName.SMASK, COSDictionary.class)).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.G, COSDictionary.class)).filter(Objects::nonNull).map(d -> (COSDictionary)d.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)).filter(Objects::nonNull);
        this.cleanResources(Stream.of(formsResources, softmaskResources).flatMap(s -> s).collect(Collectors.toSet()));
    }

    private void cleanResources(Set<COSDictionary> resources) {
        LOG.trace("Found {} distinct resource dictionaries to clean", (Object)resources.size());
        this.cleanXObject(resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.XOBJECT, COSDictionary.class)).filter(Objects::nonNull));
        this.cleanUnused(resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.FONT, COSDictionary.class)).filter(Objects::nonNull), COSName.FONT);
        this.cleanUnused(resources.stream().map(d -> (COSDictionary)d.getDictionaryObject(COSName.EXT_G_STATE, COSDictionary.class)).filter(Objects::nonNull), COSName.EXT_G_STATE);
    }

    private void cleanXObject(Stream<COSDictionary> xobjects) {
        xobjects.forEach(x -> {
            Set<COSName> toRemove = x.entrySet().stream().filter(e -> !(((COSBase)e.getValue()).getCOSObject() instanceof ReadOnlyFilteredCOSStream)).filter(e -> ((COSBase)e.getValue()).getCOSObject() instanceof COSStream).map(Map.Entry::getKey).collect(Collectors.toSet());
            LOG.trace("Removing {} unused {} from {}", new Object[]{toRemove.size(), COSName.XOBJECT.getName(), x});
            toRemove.forEach(arg_0 -> ((COSDictionary)x).removeItem(arg_0));
        });
    }

    private void cleanUnused(Stream<COSDictionary> resources, COSName type) {
        resources.forEach(f -> {
            Set<COSName> toRemove = f.entrySet().stream().filter(e -> !(((COSBase)e.getValue()).getCOSObject() instanceof InUseDictionary)).map(Map.Entry::getKey).collect(Collectors.toSet());
            LOG.trace("Removing {} unused {}", (Object)toRemove.size(), (Object)type.getName());
            toRemove.forEach(arg_0 -> ((COSDictionary)f).removeItem(arg_0));
        });
    }
}

