/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.image;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageImageWriter;
import org.sejda.model.PageOrientation;
import org.sejda.model.PageSize;
import org.sejda.model.encryption.EncryptionAtRestPolicy;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.ImageMergeInput;
import org.sejda.model.input.MergeInput;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfMergeInput;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.Source;
import org.sejda.model.input.TaskSource;
import org.sejda.model.parameter.BaseMergeParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.sejda.model.util.IOUtils;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesToPdfDocumentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesToPdfDocumentConverter.class);
    private PDDocumentHandler documentHandler = new PDDocumentHandler();
    private PageImageWriter imageWriter;

    public ImagesToPdfDocumentConverter() {
        this.documentHandler.setCreatorOnPDDocument();
        this.imageWriter = new PageImageWriter(this.documentHandler.getUnderlyingPDDocument());
    }

    public List<PDPage> addPages(Source<?> source) throws TaskException {
        return this.addPages(source, null, PageOrientation.AUTO, 0.0f);
    }

    public List<PDPage> addPages(Source<?> source, PDRectangle pageSize, PageOrientation pageOrientation, float marginInches) throws TaskException {
        this.beforeImage(source);
        LinkedList<PDPage> results = new LinkedList<PDPage>();
        try {
            int numberOfImages = 1;
            if (this.supportsMultiPageImage(source)) {
                numberOfImages = ImagesToPdfDocumentConverter.getImagePageCount(source);
            }
            for (int imageNumber = 0; imageNumber < numberOfImages; ++imageNumber) {
                float ratio;
                PDImageXObject image = PageImageWriter.toPDXImageObject(source, imageNumber);
                PDRectangle mediaBox = pageSize;
                if (mediaBox == null) {
                    mediaBox = new PDRectangle((float)image.getWidth(), (float)image.getHeight());
                }
                if (pageOrientation == PageOrientation.LANDSCAPE) {
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                } else if (pageOrientation == PageOrientation.AUTO && image.getWidth() > image.getHeight() && (float)image.getWidth() > mediaBox.getWidth()) {
                    LOG.debug("Switching to landscape, image dimensions are {}x{}", (Object)image.getWidth(), (Object)image.getHeight());
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                }
                PDPage page = this.documentHandler.addBlankPage(mediaBox);
                results.add(page);
                float width = image.getWidth();
                float height = image.getHeight();
                if (width > mediaBox.getWidth()) {
                    int targetWidth = (int)mediaBox.getWidth();
                    LOG.debug("Scaling image down to fit by width {} vs {}", (Object)Float.valueOf(width), (Object)targetWidth);
                    ratio = width / (float)targetWidth;
                    width = targetWidth;
                    height = Math.round(height / ratio);
                }
                if (height > mediaBox.getHeight()) {
                    int targetHeight = (int)mediaBox.getHeight();
                    LOG.debug("Scaling image down to fit by height {} vs {}", (Object)Float.valueOf(height), (Object)targetHeight);
                    ratio = height / (float)targetHeight;
                    height = targetHeight;
                    width = Math.round(width / ratio);
                }
                if (marginInches > 0.0f) {
                    float newWidth = width - marginInches * 72.0f;
                    float newHeight = height * newWidth / width;
                    width = newWidth;
                    height = newHeight;
                }
                float x = (mediaBox.getWidth() - width) / 2.0f;
                float y = ((float)((int)mediaBox.getHeight()) - height) / 2.0f;
                this.imageWriter.append(page, image, (Point2D)new Point((int)x, (int)y), width, height, null, 0);
                this.afterImage(image);
            }
        }
        catch (TaskIOException e) {
            this.failedImage(source, e);
        }
        return results;
    }

    public void beforeImage(Source<?> source) throws TaskException {
    }

    public void afterImage(PDImageXObject image) throws TaskException {
    }

    public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
        throw e;
    }

    public boolean supportsMultiPageImage(Source<?> source) {
        return true;
    }

    public static void convertImageMergeInputToPdf(BaseMergeParameters<MergeInput> parameters, TaskExecutionContext context) throws TaskException {
        ArrayList<Object> newInputList = new ArrayList<Object>();
        for (MergeInput input : parameters.getInputList()) {
            if (input instanceof ImageMergeInput) {
                ImageMergeInput image = (ImageMergeInput)input;
                context.notifiableTaskMetadata().setCurrentSource((TaskSource)image.getSource());
                newInputList.add(ImagesToPdfDocumentConverter.convertImagesToPdfMergeInput(image, context));
                context.notifiableTaskMetadata().clearCurrentSource();
                continue;
            }
            newInputList.add(input);
        }
        parameters.setInputList(newInputList);
    }

    public static PDRectangle toPDRectangle(PageSize pageSize) {
        return new PDRectangle(pageSize.getWidth(), pageSize.getHeight());
    }

    private static PdfMergeInput convertImagesToPdfMergeInput(ImageMergeInput image, final TaskExecutionContext context) throws TaskException {
        ImagesToPdfDocumentConverter converter = new ImagesToPdfDocumentConverter(){

            @Override
            public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
                context.assertTaskIsLenient((Exception)((Object)e));
                ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)context.notifiableTaskMetadata()).taskWarning(String.format("Image %s was skipped, could not be processed", source.getName()), (Exception)((Object)e));
            }
        };
        PDRectangle pageSize = null;
        if (image.getPageSize() != null) {
            pageSize = ImagesToPdfDocumentConverter.toPDRectangle(image.getPageSize());
        }
        if (image.isShouldPageSizeMatchImageSize()) {
            pageSize = null;
        }
        converter.addPages(image.getSource(), pageSize, image.getPageOrientation(), 0.0f);
        PDDocumentHandler converted = converter.getDocumentHandler();
        String basename = FilenameUtils.getBaseName((String)image.getSource().getName());
        String filename = String.format("%s.pdf", basename);
        File convertedTmpFile = IOUtils.createTemporaryBufferWithName((String)filename);
        converted.setDocumentTitle(basename);
        EncryptionAtRestPolicy encryptionAtRestPolicy = image.getSource().getEncryptionAtRestPolicy();
        converted.savePDDocument(convertedTmpFile, encryptionAtRestPolicy);
        PdfMergeInput input = new PdfMergeInput((PdfSource)PdfFileSource.newInstanceNoPassword((File)convertedTmpFile));
        input.getSource().setEncryptionAtRestPolicy(encryptionAtRestPolicy);
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static int getImagePageCount(Source<?> source) {
        try (ImageInputStream is = ImageIO.createImageInputStream(source.getSeekableSource().asNewInputStream());){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(is);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(is);
                try {
                    int n = reader.getNumImages(true);
                    reader.dispose();
                    return n;
                }
                catch (Throwable throwable) {
                    reader.dispose();
                    throw throwable;
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Could not determine image page count: {}", (Object)source.getName(), (Object)ex);
        }
        return 1;
    }

    public PDDocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }
}

