/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStreamProcessor
extends PDFStreamEngine
implements Consumer<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(ContentStreamProcessor.class);

    private void processAnnotation(PDAnnotation annotation) throws IOException {
        List<PDAppearanceEntry> appreaceEntries = ((Collection)Optional.ofNullable(annotation.getAppearance()).map(d -> d.getCOSObject().getValues()).filter(obj -> true).orElse(Collections.emptyList())).stream().map(COSBase::getCOSObject).filter(a -> !(a instanceof COSNull)).map(PDAppearanceEntry::new).toList();
        for (PDAppearanceEntry entry : appreaceEntries) {
            if (entry.isStream()) {
                this.processStream((PDContentStream)entry.getAppearanceStream());
                continue;
            }
            for (PDAppearanceStream stream : entry.getSubDictionary().values()) {
                if (stream == null) continue;
                this.processStream((PDContentStream)stream);
            }
        }
    }

    @Override
    public void accept(PDPage page) {
        try {
            this.processPage(page);
            for (PDAnnotation annotation : page.getAnnotations()) {
                this.processAnnotation(annotation);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed parse page, skipping and continuing with next.", (Throwable)e);
        }
    }
}

