/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sejda.commons.LookupTable;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationsDistiller {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationsDistiller.class);
    private PDDocument document;
    private LookupTable<PDAnnotation> annotationsLookup = new LookupTable();

    public AnnotationsDistiller(PDDocument document) {
        RequireUtils.requireNotNullArg((Object)document, (String)"Cannot process annotations for a null document");
        this.document = document;
    }

    public LookupTable<PDAnnotation> retainRelevantAnnotations(LookupTable<PDPage> relevantPages) {
        LOG.debug("Filtering annotations");
        for (PDPage page : relevantPages.keys()) {
            try {
                LinkedHashSet<PDAnnotation> keptAnnotations = new LinkedHashSet<PDAnnotation>();
                for (PDAnnotation annotation : page.getAnnotations()) {
                    PDAnnotation mapped = (PDAnnotation)this.annotationsLookup.lookup((Object)annotation);
                    if (Objects.nonNull(mapped)) {
                        keptAnnotations.add(mapped);
                        continue;
                    }
                    PDPage annotationPage = annotation.getPage();
                    if (annotationPage != null && !annotationPage.equals((Object)page)) {
                        if (COSName.SCREEN.equals((Object)annotation.getSubtype())) {
                            annotation.setPage(page);
                        } else {
                            annotation.setPage(null);
                        }
                    }
                    if (annotation instanceof PDAnnotationLink) {
                        this.processLinkAnnotation(relevantPages, keptAnnotations, (PDAnnotationLink)annotation, page);
                        continue;
                    }
                    this.processNonLinkAnnotation(relevantPages, keptAnnotations, annotation, page);
                }
                ((PDPage)relevantPages.lookup((Object)page)).setAnnotations(new ArrayList(keptAnnotations));
            }
            catch (IOException e) {
                LOG.warn("Failed to process annotations for page", (Throwable)e);
            }
        }
        return this.annotationsLookup;
    }

    private void processLinkAnnotation(LookupTable<PDPage> relevantPages, Set<PDAnnotation> keptAnnotations, PDAnnotationLink annotation, PDPage p) throws IOException {
        PDPageDestination destination = this.getDestinationFrom(annotation);
        if (Objects.nonNull(destination)) {
            PDPage destPage = (PDPage)relevantPages.lookup((Object)destination.getPage());
            if (Objects.nonNull(destPage)) {
                PDAnnotationLink duplicate = (PDAnnotationLink)this.duplicate((PDAnnotation)annotation, p, relevantPages);
                duplicate.getCOSObject().removeItem(COSName.A);
                PDPageDestination newDestination = (PDPageDestination)PDDestination.create((COSBase)destination.getCOSObject().duplicate());
                newDestination.setPage(destPage);
                duplicate.setDestination((PDDestination)newDestination);
                keptAnnotations.add((PDAnnotation)duplicate);
            } else {
                LOG.trace("Removing not relevant link annotation");
            }
        } else {
            keptAnnotations.add(this.duplicate((PDAnnotation)annotation, p, relevantPages));
        }
    }

    private void processNonLinkAnnotation(LookupTable<PDPage> relevantPages, Set<PDAnnotation> keptAnnotations, PDAnnotation annotation, PDPage p) {
        if (Objects.isNull(p) || relevantPages.hasLookupFor((Object)p)) {
            PDAnnotationPopup popup;
            PDAnnotation duplicate = this.duplicate(annotation, p, relevantPages);
            if (duplicate instanceof PDAnnotationMarkup && Objects.nonNull(popup = ((PDAnnotationMarkup)duplicate).getPopup())) {
                COSName subtype = popup.getCOSObject().getCOSName(COSName.SUBTYPE);
                if (COSName.POPUP.equals((Object)subtype)) {
                    PDAnnotationPopup popupDuplicate = Optional.ofNullable((PDAnnotationPopup)this.annotationsLookup.lookup((Object)popup)).orElseGet(() -> (PDAnnotationPopup)this.duplicate((PDAnnotation)popup, p, relevantPages));
                    ((PDAnnotationMarkup)duplicate).setPopup(popupDuplicate);
                    if (Objects.nonNull(popupDuplicate.getParent())) {
                        popupDuplicate.setParent((PDAnnotationMarkup)duplicate);
                        LOG.trace("Popup parent annotation updated");
                    }
                    keptAnnotations.add((PDAnnotation)popupDuplicate);
                } else {
                    ((PDAnnotationMarkup)duplicate).setPopup(null);
                    LOG.warn("Removed Popup annotation of unexpected subtype {}", (Object)subtype);
                }
            }
            keptAnnotations.add(duplicate);
        }
    }

    private PDAnnotation duplicate(PDAnnotation annotation, PDPage p, LookupTable<PDPage> relevantPages) {
        PDAnnotation duplicate = PDAnnotation.createAnnotation((COSBase)annotation.getCOSObject().duplicate());
        if (Objects.nonNull(p)) {
            duplicate.setPage((PDPage)relevantPages.lookup((Object)p));
            LOG.trace("Updated annotation page reference with the looked up page");
        }
        this.annotationsLookup.addLookupEntry((Object)annotation, (Object)duplicate);
        return duplicate;
    }

    private PDPageDestination getDestinationFrom(PDAnnotationLink link) {
        try {
            return link.resolveToPageDestination(this.document.getDocumentCatalog()).orElse(null);
        }
        catch (Exception e) {
            LOG.warn("Failed to get destination for annotation", (Throwable)e);
            return null;
        }
    }
}

