/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.Closeable;
import java.io.File;
import org.sejda.commons.util.IOUtils;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.SingleOutputWriter;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.TaskSource;
import org.sejda.model.output.ExistingOutputPolicy;
import org.sejda.model.output.TaskOutput;
import org.sejda.model.output.TaskOutputDispatcher;
import org.sejda.model.parameter.SetPagesLabelParameters;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.BaseTask;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.TaskExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPagesLabelTask
extends BaseTask<SetPagesLabelParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SetPagesLabelTask.class);
    private PDDocumentHandler documentHandler = null;
    private SingleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    public void before(SetPagesLabelParameters parameters, TaskExecutionContext executionContext) throws TaskException {
        super.before((TaskParameters)parameters, executionContext);
        this.documentLoader = new DefaultPdfSourceOpener(executionContext);
        this.outputWriter = OutputWriters.newSingleOutputWriter((ExistingOutputPolicy)parameters.getExistingOutputPolicy(), (TaskExecutionContext)executionContext);
    }

    public void execute(SetPagesLabelParameters parameters) throws TaskException {
        ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.executionContext().notifiableTaskMetadata()).progressUndetermined();
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.executionContext().notifiableTaskMetadata().setCurrentSource((TaskSource)source);
        this.documentHandler = (PDDocumentHandler)source.open(this.documentLoader);
        File tmpFile = org.sejda.model.util.IOUtils.createTemporaryBuffer((TaskOutput)parameters.getOutput());
        this.outputWriter.taskOutput(tmpFile);
        LOG.debug("Temporary output set to {}", (Object)tmpFile);
        LOG.debug("Applying {} labels ", (Object)parameters.getLabels().size());
        this.documentHandler.setPageLabelsOnDocument(parameters.getLabels());
        this.documentHandler.setCreatorOnPDDocument();
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.savePDDocument(tmpFile, parameters.getOutput().getEncryptionAtRestPolicy());
        IOUtils.closeQuietly((Closeable)this.documentHandler);
        this.executionContext().notifiableTaskMetadata().clearCurrentSource();
        parameters.getOutput().accept((TaskOutputDispatcher)this.outputWriter);
        LOG.debug("Labels applied to {}", (Object)parameters.getOutput());
    }

    public void after() {
        IOUtils.closeQuietly((Closeable)this.documentHandler);
    }
}

