/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.extract;

import java.util.function.Consumer;
import org.pdfsam.core.support.params.TaskParametersBuildStep;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.tools.extract.ExtractParametersBuilder;
import org.pdfsam.ui.components.selection.multiple.FileColumn;
import org.pdfsam.ui.components.selection.multiple.IntColumn;
import org.pdfsam.ui.components.selection.multiple.LoadingColumn;
import org.pdfsam.ui.components.selection.multiple.LongColumn;
import org.pdfsam.ui.components.selection.multiple.MultipleSelectionPane;
import org.pdfsam.ui.components.selection.multiple.SelectionTableColumn;
import org.pdfsam.ui.components.selection.multiple.TableColumnProvider;
import org.sejda.conversion.exception.ConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractSelectionPane
extends MultipleSelectionPane
implements TaskParametersBuildStep<ExtractParametersBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractSelectionPane.class);

    public ExtractSelectionPane(String ownerModule) {
        super(ownerModule, false, false, (TableColumnProvider[])new SelectionTableColumn[]{new LoadingColumn(ownerModule), FileColumn.NAME, LongColumn.SIZE, IntColumn.PAGES, LongColumn.LAST_MODIFIED});
    }

    public void apply(ExtractParametersBuilder builder, Consumer<String> onError) {
        try {
            this.table().getItems().forEach(i -> builder.addSource(i.descriptor().toPdfFileSource()));
            if (!builder.hasInput()) {
                onError.accept(I18nContext.i18n().tr("No PDF document has been selected"));
            }
        }
        catch (ConversionException e) {
            LOG.error(e.getMessage());
            onError.accept(e.getMessage());
        }
    }
}

