/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.OffsettableSeekableSource;
import org.sejda.io.SeekableSource;

class OffsettableSeekableSourceImpl
implements OffsettableSeekableSource {
    private final SeekableSource wrapped;
    private long offset = 0L;

    public OffsettableSeekableSourceImpl(SeekableSource wrapped) {
        RequireUtils.requireNotNullArg((Object)wrapped, (String)"Input decorated SeekableSource cannot be null");
        this.wrapped = wrapped;
    }

    @Override
    public String id() {
        return this.wrapped.id();
    }

    @Override
    public boolean isOpen() {
        return this.wrapped.isOpen();
    }

    @Override
    public void requireOpen() throws IOException {
        this.wrapped.requireOpen();
    }

    @Override
    public long size() {
        return this.wrapped.size() - this.offset;
    }

    @Override
    public void offset(long offset) throws IOException {
        RequireUtils.requireArg((offset >= 0L ? 1 : 0) != 0, (String)"Cannot set a negative offset");
        RequireUtils.requireArg((this.wrapped.size() - offset >= 0L ? 1 : 0) != 0, (String)"Invalid offset bigger then the wrapped source size");
        this.offset = offset;
        this.wrapped.position(this.wrapped.position() + offset);
    }

    @Override
    public long position() throws IOException {
        return this.wrapped.position() - this.offset;
    }

    @Override
    public SeekableSource position(long position) throws IOException {
        return this.wrapped.position(position + this.offset);
    }

    @Override
    public int read() throws IOException {
        return this.wrapped.read();
    }

    @Override
    public SeekableSource view(long startingPosition, long length) throws IOException {
        return this.wrapped.view(startingPosition + this.offset, length);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.wrapped.read(dst);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.wrapped);
    }
}

