/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.sound;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import javafx.scene.media.AudioClip;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.BooleanPersistentProperty;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.injector.Auto;
import org.sejda.commons.util.RequireUtils;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;

@Auto
public class PlaySoundController {
    private final String okSoundURI;
    private final String errorSoundURI;

    @Inject
    public PlaySoundController(@Named(value="okSound") String okSoundURI, @Named(value="errorSound") String errorSoundURI) {
        RequireUtils.requireNotBlank((String)okSoundURI, (String)"");
        RequireUtils.requireNotBlank((String)errorSoundURI, (String)"");
        this.okSoundURI = okSoundURI;
        this.errorSoundURI = errorSoundURI;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void playFailed(TaskExecutionFailedEvent event) {
        this.playSound(this.errorSoundURI);
    }

    @EventListener
    public void playCompleted(TaskExecutionCompletedEvent event) {
        this.playSound(this.okSoundURI);
    }

    private void playSound(String soundURI) {
        if (ApplicationContext.app().persistentSettings().get(BooleanPersistentProperty.PLAY_SOUNDS)) {
            new AudioClip(soundURI).play(1.0);
        }
    }
}

