/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.io;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.IOException;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.io.NativeOpenFileRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class NativeOpenFileController {
    private static final Logger LOG = LoggerFactory.getLogger(NativeOpenFileController.class);

    NativeOpenFileController() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void openPath(NativeOpenFileRequest event) {
        EventQueue.invokeLater(() -> this.doOpen(event));
    }

    private void doOpen(NativeOpenFileRequest event) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(event.file());
            }
            catch (IOException e) {
                LOG.error(String.format("Unable to open '%s'", event.file().getAbsoluteFile()), (Throwable)e);
            }
        }
    }
}

