/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.sidebar;

import jakarta.inject.Inject;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.shape.Circle;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.boxicons.BoxiconsRegular;
import org.kordamp.ikonli.javafx.FontIcon;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.gui.components.sidebar.SidebarButton;
import org.pdfsam.gui.components.sidebar.SidebarButtonWithNotification;
import org.pdfsam.gui.components.sidebar.SidebarNotificationType;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.news.LatestNewsResponse;
import org.pdfsam.model.news.ToggleNewsPanelRequest;

public class NewsButton
extends SidebarButtonWithNotification<SidebarButton> {
    @Inject
    public NewsButton() {
        super(new SidebarButton(I18nContext.i18n().tr("News"), (Node)new FontIcon((Ikon)BoxiconsRegular.NEWS)), SidebarButtonWithNotification.notificationOf((Node)new Circle(5.0)), SidebarNotificationType.INFO);
        this.getWrapped().setDisable(true);
        this.getWrapped().setTooltip(new Tooltip(I18nContext.i18n().tr("What's new")));
        this.getWrapped().setOnAction(e -> StaticStudio.eventStudio().broadcast((Object)ToggleNewsPanelRequest.INSTANCE));
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onLatestNews(LatestNewsResponse event) {
        if (!event.latestNews().isEmpty()) {
            Platform.runLater(() -> {
                this.getWrapped().setDisable(false);
                if (!event.isUpToDate()) {
                    this.showNotification();
                }
            });
        }
    }
}

