/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.gui.components.content.preference;

import javafx.scene.control.ComboBox;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.core.context.StringPersistentProperty;
import org.pdfsam.model.ui.ComboItem;
import org.sejda.commons.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceComboBox<T extends ComboItem<?>>
extends ComboBox<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceComboBox.class);

    PreferenceComboBox(StringPersistentProperty property) {
        this(property, ApplicationContext.app());
    }

    PreferenceComboBox(StringPersistentProperty property, ApplicationContext context) {
        RequireUtils.requireNotNullArg((Object)property, (String)"Preference cannot be null");
        this.valueProperty().addListener((observable, oldValue, newValue) -> {
            context.persistentSettings().set(property, newValue.key().toString());
            LOG.trace("Preference {} set to {}", (Object)property, newValue.key());
        });
    }
}

