/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.alternatemix;

import jakarta.inject.Named;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.unicons.UniconsLine;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Provides;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolDescriptorBuilder;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;
import org.pdfsam.tools.alternatemix.AlternateMixToolPanel;
import org.pdfsam.ui.components.io.BrowsableField;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.tool.Footer;
import org.pdfsam.ui.components.tool.OpenButton;
import org.pdfsam.ui.components.tool.RunButton;

public class AlternateMixTool
implements Tool {
    static final String TOOL_ID = "alternatemix";
    private final ToolDescriptor descriptor = ToolDescriptorBuilder.builder().category(ToolCategory.MERGE).inputTypes(new ToolInputOutputType[]{ToolInputOutputType.MULTIPLE_PDF}).name(I18nContext.i18n().tr("Alternate Mix")).description(I18nContext.i18n().tr("Merge two or more PDF documents taking pages alternately in natural or reverse order.")).priority(ToolPriority.DEFAULT.getPriority()).supportURL("https://pdfsam.org/mix-pdf/").build();

    public ToolDescriptor descriptor() {
        return this.descriptor;
    }

    public Pane panel() {
        return (Pane)ApplicationContext.app().instance(AlternateMixToolPanel.class);
    }

    public String id() {
        return TOOL_ID;
    }

    public Node graphic() {
        FontIcon icon = new FontIcon((Ikon)UniconsLine.COPY_LANDSCAPE);
        icon.getStyleClass().addAll((Object[])new String[]{this.descriptor().category().styleClass(), "tool-icon"});
        return icon;
    }

    public static class ModuleConfig {
        @Provides
        @Named(value="alternatemixfield")
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Provides
        @Named(value="alternatemixpane")
        public PdfDestinationPane destinationPane(@Named(value="alternatemixfield") BrowsablePdfOutputField outputField) {
            return new PdfDestinationPane((BrowsableField)outputField, AlternateMixTool.TOOL_ID, new PdfDestinationPane.DestinationPanelFields[0]);
        }

        @Provides
        @Named(value="alternatemixfooter")
        public Footer footer(RunButton runButton, @Named(value="alternatemixopenButton") OpenButton openButton) {
            return new Footer(runButton, openButton, AlternateMixTool.TOOL_ID);
        }

        @Provides
        @Named(value="alternatemixopenButton")
        public OpenButton openButton() {
            return new OpenButton(AlternateMixTool.TOOL_ID, ToolInputOutputType.SINGLE_PDF);
        }
    }
}

