/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.rotate;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.MultipleOutputTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.rotate.RotateOptionsPane;
import org.pdfsam.tools.rotate.RotateParametersBuilder;
import org.pdfsam.tools.rotate.RotateSelectionPane;
import org.pdfsam.ui.components.io.BrowsableOutputDirectoryField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.prefix.PrefixPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;
import org.sejda.model.prefix.Prefix;

public class RotateToolPanel
extends BaseToolPanel {
    private final RotateSelectionPane selectionPane = new RotateSelectionPane("rotate");
    private final RotateOptionsPane rotateOptions = new RotateOptionsPane();
    private final BrowsableOutputDirectoryField destinationDirectoryField;
    private final PdfDestinationPane destinationPane;
    private final PrefixPane prefix;

    @Inject
    public RotateToolPanel(@Named(value="rotatefield") BrowsableOutputDirectoryField destinationDirectoryField, @Named(value="rotatepane") PdfDestinationPane destinationPane, @Named(value="rotatefooter") Footer footer, @Named(value="rotateprefix") PrefixPane prefix) {
        super("rotate", footer);
        this.destinationDirectoryField = destinationDirectoryField;
        this.destinationPane = destinationPane;
        this.prefix = prefix;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    protected RotateParametersBuilder getBuilder(Consumer<String> onError) {
        RotateParametersBuilder builder = new RotateParametersBuilder();
        this.rotateOptions.apply(builder, onError);
        this.selectionPane.apply(builder, onError);
        this.destinationDirectoryField.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        this.prefix.apply((MultipleOutputTaskParametersBuilder)builder, onError);
        return builder;
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.rotateOptions.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
        this.destinationDirectoryField.saveStateTo(data);
        this.prefix.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.rotateOptions.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
        this.destinationDirectoryField.restoreStateFrom(data);
        this.prefix.restoreStateFrom(data);
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        TitledPane prefixTitled = Views.titledPane((String)I18nContext.i18n().tr("File names settings"), (Node)this.prefix);
        this.prefix.addMenuItemFor(new Prefix[]{Prefix.FILENUMBER});
        this.prefix.addMenuItemFor(new String[]{"[TOTAL_FILESNUMBER]"});
        TitledPane options = Views.titledPane((String)I18nContext.i18n().tr("Rotate settings"), (Node)this.rotateOptions);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, options, Views.titledPane((String)I18nContext.i18n().tr("Output settings"), (Node)this.destinationPane), prefixTitled});
        return pane;
    }

    @EventStation
    public String id() {
        return "rotate";
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.rotateOptions.resetView();
            this.prefix.resetView();
            this.destinationPane.resetView();
        }
    }
}

