/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.util;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class StringUtils {
    private StringUtils() {
    }

    public static String normalizeWhitespace(String in) {
        String result = in.replaceAll("[\\n\\t\\r]", "").replaceAll("\\p{Z}", " ").replaceAll("\\s", " ");
        result = result.replace('\u00a0', ' ');
        return result;
    }

    public static Set<Character> difference(String s1, String s2) {
        return s1.codePoints().filter(c -> s2.indexOf(c) < 0).mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());
    }

    public static String asUnicodes(String in) {
        if (Objects.nonNull(in)) {
            int codepoint;
            StringBuilder result = new StringBuilder();
            for (int offset = 0; offset < in.length(); offset += Character.charCount(codepoint)) {
                codepoint = in.codePointAt(offset);
                result.append("\\U+").append(Integer.toHexString(codepoint).toUpperCase());
            }
            return result.toString();
        }
        return null;
    }

    public static boolean isEmpty(CharSequence cs) {
        return Objects.isNull(cs) || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String normalizeLineEndings(String in) {
        return in.replaceAll("\\r\\n", "\n");
    }
}

