/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.commons.collection;

import java.util.Collection;
import java.util.LinkedList;
import org.sejda.commons.util.RequireUtils;

public class CircularLinkedList<E>
extends LinkedList<E> {
    private int maxCapacity;

    public CircularLinkedList(int maxCapacity) {
        this.setMaxCapacity(maxCapacity);
    }

    public void setMaxCapacity(int maxCapacity) {
        RequireUtils.requireArg(maxCapacity > 0, "Max capacity must be a positive value");
        this.maxCapacity = maxCapacity;
        this.houseKeep();
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean isFull() {
        return this.size() >= this.maxCapacity;
    }

    @Override
    public void addFirst(E e) {
        this.makeRoom();
        super.addFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.makeRoom();
        super.addLast(e);
    }

    @Override
    public boolean add(E e) {
        this.makeRoom();
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ret = super.addAll(c);
        this.houseKeep();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean ret = super.addAll(index, c);
        this.houseKeep();
        return ret;
    }

    @Override
    public void add(int i, E e) {
        super.add(i, e);
        this.houseKeep();
    }

    private void makeRoom() {
        while (this.isFull()) {
            this.pollFirst();
        }
    }

    private void houseKeep() {
        while (this.size() > this.maxCapacity) {
            this.pollFirst();
        }
    }
}

