/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldTree;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDXFAResource;
import org.sejda.sambox.pdmodel.interactive.form.ScriptingHandler;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDAcroForm
extends PDDictionaryWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PDAcroForm.class);
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final PDDocument document;
    private ScriptingHandler scriptingHandler;
    private final Map<COSName, SoftReference<PDFont>> directFontCache = new HashMap<COSName, SoftReference<PDFont>>();

    public PDAcroForm(PDDocument document) {
        this.document = document;
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)new COSArray());
    }

    public PDAcroForm(PDDocument document, COSDictionary form) {
        super(form);
        this.document = document;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public void flatten() throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamic XFA form is not supported");
            return;
        }
        ArrayList<PDField> fields = new ArrayList<PDField>();
        for (PDField field : this.getFieldTree()) {
            fields.add(field);
        }
        this.flatten(fields, false);
    }

    public void flatten(List<PDField> fields, boolean refreshAppearances) throws IOException {
        if (fields.isEmpty()) {
            return;
        }
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamix XFA form is not supported");
            return;
        }
        if (!refreshAppearances && this.isNeedAppearances()) {
            LOG.warn("AcroForm NeedAppearances is true, visual field appearances may not have been set");
            LOG.warn("call acroForm.refreshAppearances() or use the flatten() method with refreshAppearances parameter");
        }
        if (refreshAppearances) {
            this.refreshAppearances(fields);
        }
        Map<COSDictionary, PDAnnotationWidget> toFlatten = this.widgets(fields);
        for (PDPage page : this.document.getPages()) {
            boolean isContentStreamWrapped = false;
            ArrayList<PDAnnotation> annotations = new ArrayList<PDAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDAnnotationWidget widget = toFlatten.get(annotation.getCOSObject());
                if (Objects.isNull(widget)) {
                    annotations.add(annotation);
                    continue;
                }
                if (!this.isVisibleAnnotation(annotation)) continue;
                try (PDPageContentStream contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true, !isContentStreamWrapped);){
                    isContentStreamWrapped = true;
                    PDAppearanceStream appearanceStream = annotation.getNormalAppearanceStream();
                    PDFormXObject fieldObject = new PDFormXObject(appearanceStream.getCOSObject());
                    contentStream.saveGraphicsState();
                    Matrix transformationMatrix = this.resolveTransformationMatrix(annotation, appearanceStream);
                    contentStream.transform(transformationMatrix);
                    contentStream.drawForm(fieldObject);
                    contentStream.restoreGraphicsState();
                }
            }
            page.setAnnotations(annotations);
        }
        this.removeFields(fields);
        this.getCOSObject().removeItem(COSName.XFA);
    }

    private boolean isVisibleAnnotation(PDAnnotation annotation) {
        if (annotation.isInvisible() || annotation.isHidden()) {
            return false;
        }
        PDAppearanceStream normalAppearanceStream = annotation.getNormalAppearanceStream();
        if (normalAppearanceStream == null) {
            return false;
        }
        PDRectangle bbox = normalAppearanceStream.getBBox();
        return bbox != null && bbox.getWidth() > 0.0f && bbox.getHeight() > 0.0f;
    }

    public void refreshAppearances() throws IOException {
        for (PDField field : this.getFieldTree()) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public void refreshAppearances(List<PDField> fields) throws IOException {
        for (PDField field : fields) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public List<PDField> getFields() {
        return this.fieldsFromArray(this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class));
    }

    private List<PDField> fieldsFromArray(COSArray array) {
        if (Objects.nonNull(array) && array.size() > 0) {
            return array.stream().filter(Objects::nonNull).map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).map(d -> PDField.fromDictionary(this, (COSDictionary)d, null)).collect(Collectors.toList());
        }
        return new ArrayList<PDField>();
    }

    public void addFields(Collection<PDField> toAdd) {
        COSArray fields = Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class)).orElseGet(COSArray::new);
        for (PDField field : toAdd) {
            fields.add(field);
        }
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)fields);
    }

    public COSBase removeField(PDField remove) {
        int removeIdx;
        COSArray fields = this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class);
        if (Objects.nonNull(fields) && (removeIdx = fields.indexOfObject(remove.getCOSObject())) >= 0) {
            return fields.remove(removeIdx);
        }
        return null;
    }

    public void setFields(List<PDField> fields) {
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public Iterator<PDField> getFieldIterator() {
        return new PDFieldTree(this).iterator();
    }

    public PDFieldTree getFieldTree() {
        return new PDFieldTree(this);
    }

    public PDField getField(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        return this.getFieldTree().stream().filter(f -> f != null && fullyQualifiedName.equals(f.getFullyQualifiedName())).findFirst().orElse(null);
    }

    public String getDefaultAppearance() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.DA, COSString.class)).map(COSString::getString).orElse("");
    }

    public void setDefaultAppearance(String daValue) {
        this.getCOSObject().setString(COSName.DA, daValue);
    }

    public List<PDField> getCalculationOrder() {
        return this.fieldsFromArray(this.getCOSObject().getDictionaryObject(COSName.CO, COSArray.class));
    }

    public void setCalculationOrder(COSArray co) {
        this.getCOSObject().setItem(COSName.CO, (COSBase)co);
    }

    public boolean isNeedAppearances() {
        return this.getCOSObject().getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        this.getCOSObject().setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
    }

    public PDResources getDefaultResources() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.DR, COSDictionary.class)).map(dr -> new PDResources((COSDictionary)dr, this.document.getResourceCache(), this.directFontCache)).orElse(null);
    }

    public void setDefaultResources(PDResources dr) {
        this.getCOSObject().setItem(COSName.DR, (COSObjectable)dr);
    }

    public boolean hasXFA() {
        return this.getCOSObject().containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.XFA, COSDictionary.class)).map(PDXFAResource::new).orElse(null);
    }

    public void setXFA(PDXFAResource xfa) {
        this.getCOSObject().setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQuadding() {
        return this.getCOSObject().getInt(COSName.Q, 0);
    }

    public void setQuadding(int q) {
        this.getCOSObject().setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }

    public ScriptingHandler getScriptingHandler() {
        return this.scriptingHandler;
    }

    public void setScriptingHandler(ScriptingHandler scriptingHandler) {
        this.scriptingHandler = scriptingHandler;
    }

    private Matrix resolveTransformationMatrix(PDAnnotation annotation, PDAppearanceStream appearanceStream) {
        Rectangle2D transformedAppearanceBox = this.getTransformedAppearanceBBox(appearanceStream);
        PDRectangle annotationRect = annotation.getRectangle();
        Matrix transformationMatrix = new Matrix();
        transformationMatrix.translate((float)((double)annotationRect.getLowerLeftX() - transformedAppearanceBox.getX()), (float)((double)annotationRect.getLowerLeftY() - transformedAppearanceBox.getY()));
        transformationMatrix.scale((float)((double)annotationRect.getWidth() / transformedAppearanceBox.getWidth()), (float)((double)annotationRect.getHeight() / transformedAppearanceBox.getHeight()));
        return transformationMatrix;
    }

    private Rectangle2D getTransformedAppearanceBBox(PDAppearanceStream appearanceStream) {
        Matrix appearanceStreamMatrix = appearanceStream.getMatrix();
        PDRectangle appearanceStreamBBox = appearanceStream.getBBox();
        GeneralPath transformedAppearanceBox = appearanceStreamBBox.transform(appearanceStreamMatrix);
        return transformedAppearanceBox.getBounds2D();
    }

    private Map<COSDictionary, PDAnnotationWidget> widgets(List<PDField> fields) {
        HashMap<COSDictionary, PDAnnotationWidget> widgetMap = new HashMap<COSDictionary, PDAnnotationWidget>();
        for (PDField field : fields) {
            for (PDAnnotationWidget widget : field.getWidgets()) {
                widgetMap.put(widget.getCOSObject(), widget);
            }
        }
        return widgetMap;
    }

    private Map<COSDictionary, Set<COSDictionary>> buildPagesWidgetsMap(List<PDField> fields) throws IOException {
        HashMap<COSDictionary, Set<COSDictionary>> pagesAnnotationsMap = new HashMap<COSDictionary, Set<COSDictionary>>();
        boolean hasMissingPageRef = false;
        for (PDField field : fields) {
            List<PDAnnotationWidget> widgets = field.getWidgets();
            for (PDAnnotationWidget widget : widgets) {
                PDPage page = widget.getPage();
                if (page != null) {
                    this.fillPagesAnnotationMap(pagesAnnotationsMap, page, widget);
                    continue;
                }
                hasMissingPageRef = true;
            }
        }
        if (!hasMissingPageRef) {
            return pagesAnnotationsMap;
        }
        LOG.warn("There has been a widget with a missing page reference, will check all page annotations");
        for (PDPage page : this.document.getPages()) {
            for (PDAnnotation annotation : page.getAnnotations()) {
                if (!(annotation instanceof PDAnnotationWidget)) continue;
                this.fillPagesAnnotationMap(pagesAnnotationsMap, page, (PDAnnotationWidget)annotation);
            }
        }
        return pagesAnnotationsMap;
    }

    private void fillPagesAnnotationMap(Map<COSDictionary, Set<COSDictionary>> pagesAnnotationsMap, PDPage page, PDAnnotationWidget widget) {
        Set<COSDictionary> widgetsForPage = pagesAnnotationsMap.get(page.getCOSObject());
        if (widgetsForPage == null) {
            widgetsForPage = new HashSet<COSDictionary>();
            widgetsForPage.add(widget.getCOSObject());
            pagesAnnotationsMap.put(page.getCOSObject(), widgetsForPage);
        } else {
            widgetsForPage.add(widget.getCOSObject());
        }
    }

    private void removeFields(List<PDField> fields) {
        for (PDField current : fields) {
            if (Objects.nonNull(current.getParent())) {
                current.getParent().removeChild(current);
                continue;
            }
            if (!Objects.isNull(this.removeField(current))) continue;
            LOG.warn("Unable to remove root field {}, not found", (Object)current.getFullyQualifiedName());
        }
    }
}

