/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.pattern;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.graphics.pattern.PDShadingPattern;
import org.sejda.sambox.pdmodel.graphics.pattern.PDTilingPattern;
import org.sejda.sambox.util.Matrix;

public abstract class PDAbstractPattern
implements COSObjectable {
    public static final int TYPE_TILING_PATTERN = 1;
    public static final int TYPE_SHADING_PATTERN = 2;
    private final COSDictionary patternDictionary;

    public static PDAbstractPattern create(COSDictionary resourceDictionary) throws IOException {
        return PDAbstractPattern.create(resourceDictionary, null);
    }

    public static PDAbstractPattern create(COSDictionary resourceDictionary, ResourceCache resourceCache) throws IOException {
        int patternType = resourceDictionary.getInt(COSName.PATTERN_TYPE, 0);
        return switch (patternType) {
            case 1 -> new PDTilingPattern(resourceDictionary, resourceCache);
            case 2 -> new PDShadingPattern(resourceDictionary);
            default -> throw new IOException("Error: Unknown pattern type " + patternType);
        };
    }

    public PDAbstractPattern() {
        this.patternDictionary = new COSDictionary();
        this.patternDictionary.setName(COSName.TYPE, COSName.PATTERN.getName());
    }

    public PDAbstractPattern(COSDictionary resourceDictionary) {
        this.patternDictionary = resourceDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.patternDictionary;
    }

    public void setPaintType(int paintType) {
        this.patternDictionary.setInt(COSName.PAINT_TYPE, paintType);
    }

    public String getType() {
        return COSName.PATTERN.getName();
    }

    public void setPatternType(int patternType) {
        this.patternDictionary.setInt(COSName.PATTERN_TYPE, patternType);
    }

    public abstract int getPatternType();

    public Matrix getMatrix() {
        return Matrix.createMatrix(this.getCOSObject().getDictionaryObject(COSName.MATRIX));
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSObject().setItem(COSName.MATRIX, (COSBase)matrix);
    }
}

