/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.image;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.ImagingOpException;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.graphics.color.PDJPXColorSpace;
import org.sejda.sambox.pdmodel.graphics.image.CCITTFactory;
import org.sejda.sambox.pdmodel.graphics.image.JPEGFactory;
import org.sejda.sambox.pdmodel.graphics.image.LosslessFactory;
import org.sejda.sambox.pdmodel.graphics.image.PDImage;
import org.sejda.sambox.pdmodel.graphics.image.SampledImageReader;
import org.sejda.sambox.pdmodel.graphics.image.UnsupportedImageFormatException;
import org.sejda.sambox.util.filetypedetector.FileType;
import org.sejda.sambox.util.filetypedetector.FileTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private static final Logger LOG = LoggerFactory.getLogger(PDImageXObject.class);
    private SoftReference<BufferedImage> cachedImage;
    private PDColorSpace colorSpace;
    private PDResources resources;

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    public PDImageXObject() throws IOException {
        this(new PDStream(), (PDResources)null);
    }

    public PDImageXObject(InputStream encodedStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(PDImageXObject.createRawStream(encodedStream), COSName.IMAGE);
        this.getCOSObject().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    private static COSStream createRawStream(InputStream rawInput) throws IOException {
        COSStream stream = new COSStream();
        try (OutputStream output = stream.createFilteredStream();){
            IOUtils.copy((InputStream)rawInput, (OutputStream)output);
        }
        return stream;
    }

    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        super(stream, COSName.IMAGE);
        this.resources = resources;
        List<COSName> filters = stream.getFilters();
        if (filters != null && !filters.isEmpty() && COSName.JPX_DECODE.equals(filters.get(filters.size() - 1))) {
            DecodeResult decodeResult = stream.getCOSObject().getDecodeResult();
            stream.getCOSObject().addAll(decodeResult.getParameters());
            this.colorSpace = decodeResult.getJPXColorSpace();
        }
    }

    public static PDImageXObject createFromFile(String imagePath) throws IOException {
        return PDImageXObject.createFromFile(new File(imagePath));
    }

    public static PDImageXObject createFromFile(File file) throws IOException {
        RequireUtils.requireNotNullArg((Object)file, (String)"Cannot create image from a null file");
        try (SeekableSource source = SeekableSources.seekableSourceFrom((File)file);){
            PDImageXObject pDImageXObject = PDImageXObject.createFromSeekableSource(source, file.getName());
            return pDImageXObject;
        }
    }

    public static PDImageXObject createFromSeekableSource(SeekableSource source, String filename) throws IOException {
        return PDImageXObject.createFromSeekableSource(source, filename, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage read(InputStream inputStream, int number) throws IOException {
        if (number == 0) {
            return ImageIO.read(inputStream);
        }
        BufferedImage image = null;
        ImageInputStream iis = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            reader.setInput(iis);
            try {
                image = reader.read(number);
            }
            finally {
                reader.dispose();
                iis.close();
            }
        }
        return image;
    }

    public static PDImageXObject createFromSeekableSource(SeekableSource source, String filename, int number) throws IOException {
        BufferedImage image;
        FileType fileType = FileTypeDetector.detectFileType(source);
        if (fileType.equals((Object)FileType.JPEG)) {
            return JPEGFactory.createFromSeekableSource(source);
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            try {
                return CCITTFactory.createFromSeekableSource(source, number);
            }
            catch (IOException ex) {
                LOG.warn("Reading as TIFF failed using CCITTFactory, falling back to ImageIO: {}", (Object)ex.getMessage());
            }
        }
        try {
            image = PDImageXObject.read(source.asNewInputStream(), number);
        }
        catch (Exception e) {
            LOG.warn(String.format("An error occurred while reading image: %s type: %s", new Object[]{filename, fileType}), (Throwable)e);
            throw new UnsupportedImageFormatException(fileType, filename, e);
        }
        if (image == null) {
            LOG.warn(String.format("Could not read image format: %s type: %s", new Object[]{filename, fileType}));
            throw new UnsupportedImageFormatException(fileType, filename, null);
        }
        return LosslessFactory.createFromImage(image);
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.METADATA, COSStream.class);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSObject().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENT);
    }

    public void setStructParent(int key) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public BufferedImage getImage() throws IOException {
        BufferedImage cached;
        if (this.cachedImage != null && (cached = this.cachedImage.get()) != null) {
            return cached;
        }
        PDImageXObject softMask = this.getSoftMask();
        PDImageXObject mask = this.getMask();
        BufferedImage image = softMask != null ? this.applyMask(SampledImageReader.getRGBImage(this, this.getColorKeyMask()), softMask.getOpaqueImage(), softMask.getInterpolate(), true, this.extractMatte(softMask)) : (mask != null && mask.isStencil() ? this.applyMask(SampledImageReader.getRGBImage(this, this.getColorKeyMask()), mask.getOpaqueImage(), mask.getInterpolate(), false, null) : SampledImageReader.getRGBImage(this, this.getColorKeyMask()));
        this.cachedImage = new SoftReference<BufferedImage>(image);
        return image;
    }

    @Override
    public BufferedImage getRawImage() throws IOException {
        return this.getColorSpace().toRawImage(this.getRawRaster());
    }

    @Override
    public WritableRaster getRawRaster() throws IOException {
        return SampledImageReader.getRawRaster(this);
    }

    private float[] extractMatte(PDImageXObject softMask) throws IOException {
        float[] matte = Optional.ofNullable(softMask.getCOSObject().getDictionaryObject(COSName.MATTE, COSArray.class)).map(COSArray::toFloatArray).orElse(null);
        if (Objects.nonNull(matte)) {
            PDColorSpace colorSpace = this.getColorSpace();
            if (colorSpace instanceof PDJPXColorSpace) {
                colorSpace = PDDeviceRGB.INSTANCE;
            }
            if (matte.length < colorSpace.getNumberOfComponents()) {
                LOG.error("Image /Matte entry not long enough for colorspace, skipped");
                return null;
            }
            return colorSpace.toRGB(matte);
        }
        return null;
    }

    public BufferedImage getImageWithoutMasks() throws IOException {
        return SampledImageReader.getRGBImage(this, this.getColorKeyMask());
    }

    @Override
    public BufferedImage getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public BufferedImage getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private BufferedImage applyMask(BufferedImage image, BufferedImage mask, boolean interpolateMask, boolean isSoft, float[] matte) {
        if (mask == null) {
            return image;
        }
        int width = Math.max(image.getWidth(), mask.getWidth());
        int height = Math.max(image.getHeight(), mask.getHeight());
        if (mask.getWidth() < width || mask.getHeight() < height) {
            mask = PDImageXObject.scaleImage(mask, width, height, 10, interpolateMask);
        } else if (mask.getType() != 10) {
            mask = PDImageXObject.scaleImage(mask, width, height, 10, false);
        }
        if (image.getWidth() < width || image.getHeight() < height) {
            image = PDImageXObject.scaleImage(image, width, height, 2, this.getInterpolate());
        } else if (image.getType() != 2) {
            image = PDImageXObject.scaleImage(image, width, height, 2, false);
        }
        WritableRaster raster = image.getRaster();
        WritableRaster alpha = mask.getRaster();
        if (!isSoft && raster.getDataBuffer().getSize() == alpha.getDataBuffer().getSize()) {
            DataBuffer dst = raster.getDataBuffer();
            DataBuffer src = alpha.getDataBuffer();
            int i = 0;
            for (int c = dst.getSize(); c > 0; --c) {
                dst.setElem(i, dst.getElem(i) & 0xFFFFFF | ~src.getElem(i) << 24);
                ++i;
            }
        } else if (matte == null) {
            int[] samples = new int[width];
            for (int y = 0; y < height; ++y) {
                alpha.getSamples(0, y, width, 1, 0, samples);
                if (!isSoft) {
                    int x = 0;
                    while (x < width) {
                        int n = x++;
                        samples[n] = ~samples[n];
                    }
                }
                raster.setSamples(0, y, width, 1, 3, samples);
            }
        } else {
            int[] alphas = new int[width];
            int[] pixels = new int[4 * width];
            int fraction = 15;
            int factor = 8355840;
            int m0 = Math.round(8355840.0f * matte[0]) * 255;
            int m1 = Math.round(8355840.0f * matte[1]) * 255;
            int m2 = Math.round(8355840.0f * matte[2]) * 255;
            int m0h = m0 / 255 + 16384;
            int m1h = m1 / 255 + 16384;
            int m2h = m2 / 255 + 16384;
            for (int y = 0; y < height; ++y) {
                raster.getPixels(0, y, width, 1, pixels);
                alpha.getSamples(0, y, width, 1, 0, alphas);
                int offset = 0;
                for (int x = 0; x < width; ++x) {
                    int a = alphas[x];
                    if (a == 0) {
                        offset += 3;
                    } else {
                        pixels[offset] = this.clampColor((pixels[offset++] * 8355840 - m0) / a + m0h >> 15);
                        pixels[offset] = this.clampColor((pixels[offset++] * 8355840 - m1) / a + m1h >> 15);
                        pixels[offset] = this.clampColor((pixels[offset++] * 8355840 - m2) / a + m2h >> 15);
                    }
                    pixels[offset++] = a;
                }
                raster.setPixels(0, y, width, 1, pixels);
            }
        }
        return image;
    }

    private int clampColor(float color) {
        return color < 0.0f ? 0 : (color > 255.0f ? 255 : Math.round(color));
    }

    private static BufferedImage scaleImage(BufferedImage image, int width, int height, int type, boolean interpolate) {
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        boolean largeScale = width * height > 9000000 * (type == 10 ? 3 : 1);
        boolean bl = imgWidth != width || imgHeight != height;
        BufferedImage image2 = new BufferedImage(width, height, type);
        if (interpolate &= bl) {
            AffineTransform af = AffineTransform.getScaleInstance((double)width / (double)imgWidth, (double)height / (double)imgHeight);
            AffineTransformOp afo = new AffineTransformOp(af, largeScale ? 2 : 3);
            try {
                afo.filter(image, image2);
                return image2;
            }
            catch (ImagingOpException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        Graphics2D g = image2.createGraphics();
        if (interpolate) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, largeScale ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, largeScale ? RenderingHints.VALUE_RENDER_DEFAULT : RenderingHints.VALUE_RENDER_QUALITY);
        }
        g.drawImage(image, 0, 0, width, height, 0, 0, imgWidth, imgHeight, null);
        g.dispose();
        return image2;
    }

    public boolean hasMask() {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.MASK, COSStream.class);
        return cosStream != null;
    }

    public PDImageXObject getMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.MASK, COSStream.class);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        return this.getCOSObject().getDictionaryObject(COSName.MASK, COSArray.class);
    }

    public boolean hasSoftMask() {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.SMASK, COSStream.class);
        return cosStream != null;
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.SMASK, COSStream.class);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.getCOSObject().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSObject().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSObject().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.getStream().createInputStream();
    }

    @Override
    public ByteBuffer asByteBuffer() throws IOException {
        return this.getStream().getCOSObject().getUnfilteredByteBuffer();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.getStream().getCOSObject().isEmpty();
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSObject().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
        this.colorSpace = null;
        this.cachedImage = null;
    }

    @Override
    public int getHeight() {
        return this.getCOSObject().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSObject().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSObject().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSObject().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSObject().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSObject().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSObject().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSObject().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSObject().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSObject().setBoolean(COSName.IMAGE_MASK, isStencil);
    }

    public PDPropertyList getOptionalContent() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.OC, COSDictionary.class)).map(PDPropertyList::create).orElse(null);
    }

    public void setOptionalContent(PDPropertyList oc) {
        this.getCOSObject().setItem(COSName.OC, (COSObjectable)oc);
    }
}

