/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.pdmodel.font.CIDFontMapping;
import org.sejda.sambox.pdmodel.font.FileSystemFontProvider;
import org.sejda.sambox.pdmodel.font.FontFormat;
import org.sejda.sambox.pdmodel.font.FontInfo;
import org.sejda.sambox.pdmodel.font.FontMapper;
import org.sejda.sambox.pdmodel.font.FontMapping;
import org.sejda.sambox.pdmodel.font.FontProvider;
import org.sejda.sambox.pdmodel.font.NoopFontProvider;
import org.sejda.sambox.pdmodel.font.PDCIDSystemInfo;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDPanoseClassification;
import org.sejda.sambox.pdmodel.font.Standard14Fonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FontMapperImpl
implements FontMapper {
    private final CompletableFuture<Map<String, FontInfo>> fontInfoByName;
    private final TrueTypeFont lastResortFont;
    private static final Logger LOG = LoggerFactory.getLogger(FontMapperImpl.class);
    private final Map<String, List<String>> substitutes = new HashMap<String, List<String>>();

    FontMapperImpl() {
        this(FontMapperImpl.loadFontProvider());
    }

    FontMapperImpl(FontProvider fontProvider) {
        this.fontInfoByName = CompletableFuture.supplyAsync(() -> {
            LinkedHashMap map = new LinkedHashMap();
            fontProvider.getFontInfo().forEach(info -> this.getPostScriptNames(info.getPostScriptName()).forEach(name -> map.put(name.toLowerCase(Locale.ENGLISH), info)));
            return map;
        });
        this.addSubstitutes("Courier", new ArrayList<String>(Arrays.asList("CourierNew", "CourierNewPSMT", "LiberationMono", "NimbusMonL-Regu")));
        this.addSubstitutes("Courier-Bold", new ArrayList<String>(Arrays.asList("CourierNewPS-BoldMT", "CourierNew-Bold", "LiberationMono-Bold", "NimbusMonL-Bold")));
        this.addSubstitutes("Courier-Oblique", new ArrayList<String>(Arrays.asList("CourierNewPS-ItalicMT", "CourierNew-Italic", "LiberationMono-Italic", "NimbusMonL-ReguObli")));
        this.addSubstitutes("Courier-BoldOblique", new ArrayList<String>(Arrays.asList("CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", "LiberationMono-BoldItalic", "NimbusMonL-BoldObli")));
        this.addSubstitutes("Helvetica", new ArrayList<String>(Arrays.asList("ArialMT", "Arial", "LiberationSans", "NimbusSanL-Regu")));
        this.addSubstitutes("Helvetica-Bold", new ArrayList<String>(Arrays.asList("Arial-BoldMT", "Arial-Bold", "LiberationSans-Bold", "NimbusSanL-Bold")));
        this.addSubstitutes("Helvetica-Oblique", new ArrayList<String>(Arrays.asList("Arial-ItalicMT", "Arial-Italic", "Helvetica-Italic", "LiberationSans-Italic", "NimbusSanL-ReguItal")));
        this.addSubstitutes("Helvetica-BoldOblique", new ArrayList<String>(Arrays.asList("Arial-BoldItalicMT", "Helvetica-BoldItalic", "LiberationSans-BoldItalic", "NimbusSanL-BoldItal")));
        this.addSubstitutes("Times-Roman", new ArrayList<String>(Arrays.asList("TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", "LiberationSerif", "NimbusRomNo9L-Regu")));
        this.addSubstitutes("Times-Bold", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-BoldMT", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", "LiberationSerif-Bold", "NimbusRomNo9L-Medi")));
        this.addSubstitutes("Times-Italic", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-ItalicMT", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", "LiberationSerif-Italic", "NimbusRomNo9L-ReguItal")));
        this.addSubstitutes("Times-BoldItalic", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-BoldItalicMT", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", "LiberationSerif-BoldItalic", "NimbusRomNo9L-MediItal")));
        this.addSubstitutes("Symbol", new ArrayList<String>(Arrays.asList("Symbol", "SymbolMT", "StandardSymL", "ChromSymbolOTF")));
        this.addSubstitutes("ZapfDingbats", new ArrayList<String>(Arrays.asList("ZapfDingbatsITCbyBT-Regular", "ZapfDingbatsITC", "Dingbats", "MS-Gothic", "ChromDingbatsOTF")));
        for (String baseName : Standard14Fonts.getNames()) {
            if (!this.getSubstitutes(baseName).isEmpty()) continue;
            String mappedName = Standard14Fonts.getMappedFontName(baseName);
            this.addSubstitutes(baseName, this.copySubstitutes(mappedName.toLowerCase(Locale.ENGLISH)));
        }
        this.lastResortFont = FontMapperImpl.loadLastResortFont();
    }

    public TrueTypeFont getLastResortFont() {
        return this.lastResortFont;
    }

    public static TrueTypeFont loadLastResortFont() {
        try {
            InputStream stream = FontMapperImpl.class.getResourceAsStream("/org/sejda/sambox/resources/ttf/LiberationSans-Regular.ttf");
            RequireUtils.requireNotNullArg((Object)stream, (String)"Unable to load org/sejda/sambox/resources/ttf/LiberationSans-Regular.ttf");
            return new TTFParser().parse((InputStream)new BufferedInputStream(stream));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static FontProvider loadFontProvider() {
        String configuredFontProvider = System.getProperty("org.sejda.sambox.font.provider");
        if ("noop".equalsIgnoreCase(configuredFontProvider)) {
            return new NoopFontProvider();
        }
        if (configuredFontProvider != null && !configuredFontProvider.isEmpty()) {
            try {
                LOG.debug("Trying to use {} as font provider...", (Object)configuredFontProvider);
                return (FontProvider)Class.forName(configuredFontProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                LOG.error("Failed loading custom font provider", (Throwable)ex);
            }
        }
        return new FileSystemFontProvider();
    }

    private Set<String> getPostScriptNames(String postScriptName) {
        HashSet<String> names = new HashSet<String>(2);
        names.add(postScriptName);
        names.add(postScriptName.replace("-", ""));
        return names;
    }

    private List<String> copySubstitutes(String postScriptName) {
        return new ArrayList<String>((Collection)this.substitutes.get(postScriptName));
    }

    public void addSubstitute(String match, String replace) {
        String lowerCaseMatch = match.toLowerCase(Locale.ENGLISH);
        if (!this.substitutes.containsKey(lowerCaseMatch)) {
            this.substitutes.put(lowerCaseMatch, new ArrayList());
        }
        this.substitutes.get(lowerCaseMatch).add(replace);
    }

    private void addSubstitutes(String match, List<String> replacements) {
        this.substitutes.put(match.toLowerCase(Locale.ENGLISH), replacements);
    }

    private List<String> getSubstitutes(String postScriptName) {
        List<String> subs = this.substitutes.get(postScriptName.replace(" ", "").toLowerCase(Locale.ENGLISH));
        if (subs != null) {
            return subs;
        }
        return Collections.emptyList();
    }

    private String getFallbackFontName(PDFontDescriptor fontDescriptor) {
        Object fontName;
        if (fontDescriptor != null) {
            boolean isBold = false;
            String name = fontDescriptor.getFontName();
            if (name != null) {
                String lower = fontDescriptor.getFontName().toLowerCase();
                boolean bl = isBold = lower.contains("bold") || lower.contains("black") || lower.contains("heavy");
            }
            if (fontDescriptor.isFixedPitch()) {
                fontName = "Courier";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = (String)fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = (String)fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = (String)fontName + "-Oblique";
                }
            } else if (fontDescriptor.isSerif()) {
                fontName = "Times";
                fontName = isBold && fontDescriptor.isItalic() ? (String)fontName + "-BoldItalic" : (isBold ? (String)fontName + "-Bold" : (fontDescriptor.isItalic() ? (String)fontName + "-Italic" : (String)fontName + "-Roman"));
            } else {
                fontName = "Helvetica";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = (String)fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = (String)fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = (String)fontName + "-Oblique";
                }
            }
        } else {
            fontName = "Times-Roman";
        }
        return fontName;
    }

    @Override
    public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new FontMapping<TrueTypeFont>(ttf, false);
        }
        String fontName = this.getFallbackFontName(fontDescriptor);
        ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, fontName);
        if (ttf == null) {
            ttf = this.lastResortFont;
        }
        return new FontMapping<TrueTypeFont>(ttf, true);
    }

    @Override
    public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = this.findFontBoxFont(baseFont);
        if (font != null) {
            return new FontMapping<FontBoxFont>(font, false);
        }
        String fallbackName = this.getFallbackFontName(fontDescriptor);
        font = this.findFontBoxFont(fallbackName);
        if (font == null) {
            font = this.lastResortFont;
        }
        return new FontMapping<FontBoxFont>(font, true);
    }

    private FontBoxFont findFontBoxFont(String postScriptName) {
        Type1Font t1 = (Type1Font)this.findFont(FontFormat.PFB, postScriptName);
        if (t1 != null) {
            return t1;
        }
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, postScriptName);
        if (ttf != null) {
            return ttf;
        }
        return this.findFont(FontFormat.OTF, postScriptName);
    }

    private FontBoxFont findFont(FontFormat format, String postScriptName) {
        if (postScriptName == null) {
            return null;
        }
        FontInfo info = this.getFont(format, postScriptName);
        if (info != null) {
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replace("-", ""));
        if (info != null) {
            return info.getFont();
        }
        for (String substituteName : this.getSubstitutes(postScriptName)) {
            info = this.getFont(format, substituteName);
            if (info == null) continue;
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replaceAll(",", "-"));
        if (info != null) {
            return info.getFont();
        }
        info = this.getFont(format, postScriptName + "-Regular");
        if (info != null) {
            return info.getFont();
        }
        return null;
    }

    private FontInfo getFont(FontFormat format, String postScriptName) {
        FontInfo info;
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf(43) + 1);
        }
        if ((info = this.fontInfoByName.join().get(postScriptName.toLowerCase(Locale.ENGLISH))) != null && info.getFormat() == format) {
            return info;
        }
        return null;
    }

    @Override
    public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue;
        FontMatch bestMatch;
        String collection;
        OpenTypeFont otf1 = (OpenTypeFont)this.findFont(FontFormat.OTF, baseFont);
        if (otf1 != null) {
            return new CIDFontMapping(otf1, null, false);
        }
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
        if (ttf != null) {
            return new CIDFontMapping(null, (FontBoxFont)ttf, false);
        }
        if (cidSystemInfo != null && ((collection = cidSystemInfo.getRegistry() + "-" + cidSystemInfo.getOrdering()).equals("Adobe-GB1") || collection.equals("Adobe-CNS1") || collection.equals("Adobe-Japan1") || collection.equals("Adobe-Korea1")) && (bestMatch = (queue = this.getFontMatches(fontDescriptor, cidSystemInfo)).poll()) != null) {
            FontBoxFont font = bestMatch.info.getFont();
            if (font instanceof OpenTypeFont) {
                return new CIDFontMapping((OpenTypeFont)font, null, true);
            }
            if (font != null) {
                return new CIDFontMapping(null, font, true);
            }
        }
        return new CIDFontMapping(null, (FontBoxFont)this.lastResortFont, true);
    }

    private PriorityQueue<FontMatch> getFontMatches(PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue = new PriorityQueue<FontMatch>(20);
        for (FontInfo info : this.fontInfoByName.join().values()) {
            if (cidSystemInfo != null && !this.isCharSetMatch(cidSystemInfo, info)) continue;
            FontMatch match = new FontMatch(info);
            if (fontDescriptor.getPanose() != null && info.getPanose() != null) {
                PDPanoseClassification panose = fontDescriptor.getPanose().getPanose();
                if (panose.getFamilyKind() == info.getPanose().getFamilyKind()) {
                    if (panose.getFamilyKind() == 0 && (info.getPostScriptName().toLowerCase().contains("barcode") || info.getPostScriptName().startsWith("Code")) && !FontMapperImpl.probablyBarcodeFont(fontDescriptor)) continue;
                    if (panose.getSerifStyle() == info.getPanose().getSerifStyle()) {
                        match.score += 2.0;
                    } else if (panose.getSerifStyle() >= 2 && panose.getSerifStyle() <= 5 && info.getPanose().getSerifStyle() >= 2 && info.getPanose().getSerifStyle() <= 5) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() >= 11 && panose.getSerifStyle() <= 13 && info.getPanose().getSerifStyle() >= 11 && info.getPanose().getSerifStyle() <= 13) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() != 0 && info.getPanose().getSerifStyle() != 0) {
                        match.score -= 1.0;
                    }
                    int weight = info.getPanose().getWeight();
                    int weightClass = info.getWeightClassAsPanose();
                    if (Math.abs(weight - weightClass) > 2) {
                        weight = weightClass;
                    }
                    if (panose.getWeight() == weight) {
                        match.score += 2.0;
                    } else if (panose.getWeight() > 1 && weight > 1) {
                        float dist = Math.abs(panose.getWeight() - weight);
                        match.score += 1.0 - (double)dist * 0.5;
                    }
                }
            } else if (fontDescriptor.getFontWeight() > 0.0f && info.getWeightClass() > 0) {
                float dist = Math.abs(fontDescriptor.getFontWeight() - (float)info.getWeightClass());
                match.score += 1.0 - (double)(dist / 100.0f) * 0.5;
            }
            queue.add(match);
        }
        return queue;
    }

    private static boolean probablyBarcodeFont(PDFontDescriptor fontDescriptor) {
        String ff = Optional.ofNullable(fontDescriptor.getFontFamily()).orElse("");
        String fn = Optional.ofNullable(fontDescriptor.getFontName()).orElse("");
        return ff.startsWith("Code") || ff.toLowerCase().contains("barcode") || fn.startsWith("Code") || fn.toLowerCase().contains("barcode");
    }

    private boolean isCharSetMatch(PDCIDSystemInfo cidSystemInfo, FontInfo info) {
        if (info.getCIDSystemInfo() != null) {
            return info.getCIDSystemInfo().getRegistry().equals(cidSystemInfo.getRegistry()) && info.getCIDSystemInfo().getOrdering().equals(cidSystemInfo.getOrdering());
        }
        long codePageRange = info.getCodePageRange();
        long JIS_JAPAN = 131072L;
        long CHINESE_SIMPLIFIED = 262144L;
        long KOREAN_WANSUNG = 524288L;
        long CHINESE_TRADITIONAL = 0x100000L;
        long KOREAN_JOHAB = 0x200000L;
        if ("MalgunGothic-Semilight".equals(info.getPostScriptName())) {
            codePageRange &= (JIS_JAPAN | CHINESE_SIMPLIFIED | CHINESE_TRADITIONAL) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (cidSystemInfo.getOrdering().equals("GB1") && (codePageRange & CHINESE_SIMPLIFIED) == CHINESE_SIMPLIFIED) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("CNS1") && (codePageRange & CHINESE_TRADITIONAL) == CHINESE_TRADITIONAL) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("Japan1") && (codePageRange & JIS_JAPAN) == JIS_JAPAN) {
            return true;
        }
        return cidSystemInfo.getOrdering().equals("Korea1") && ((codePageRange & KOREAN_WANSUNG) == KOREAN_WANSUNG || (codePageRange & KOREAN_JOHAB) == KOREAN_JOHAB);
    }

    private static class FontMatch
    implements Comparable<FontMatch> {
        double score;
        final FontInfo info;

        FontMatch(FontInfo info) {
            this.info = info;
        }

        @Override
        public int compareTo(FontMatch match) {
            return Double.compare(match.score, this.score);
        }
    }
}

