/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.font.FontUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTTFSubsetter
implements Function<String, COSStream> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTTFSubsetter.class);
    private static final byte[] PAD_BUF = new byte[]{0, 0, 0};
    private final SeekableSource fontSource;
    private final SortedSet<Integer> glyphIds = new TreeSet<Integer>();
    private final SortedMap<Integer, Integer> codeToGIDLookup = new TreeMap<Integer, Integer>();
    private final COSStream fontFileStream;
    private final COSDictionary existingFont;
    private TrueTypeFont font;
    private int numberOfGlyphs;

    public BaseTTFSubsetter(COSDictionary existingFont, COSStream fontFileStream, TrueTypeFont font) throws IOException {
        this.existingFont = Objects.requireNonNull(existingFont);
        this.fontFileStream = Objects.requireNonNull(fontFileStream);
        this.fontSource = fontFileStream.getUnfilteredSource();
        this.font = font;
        this.glyphIds.add(0);
    }

    public BaseTTFSubsetter(COSDictionary existingFont, COSStream fontFileStream) throws IOException {
        this(existingFont, fontFileStream, null);
    }

    public void putAll(Map<Integer, Integer> codesToGID) {
        this.codeToGIDLookup.putAll(codesToGID);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public COSStream apply(String subsetFontName) {
        String existingFontName = this.existingFont.getNameAsString(COSName.BASE_FONT);
        LOG.debug("Subsetting {}", (Object)existingFontName);
        try (TrueTypeFont font = this.getFont();){
            if (!FontUtils.isSubsettingPermitted(font)) return null;
            RequireUtils.requireState((!this.codeToGIDLookup.isEmpty() ? 1 : 0) != 0, (String)"Unable to subset, no glyph was specified");
            this.glyphIds.addAll(this.codeToGIDLookup.values());
            this.addCompositeGlyphs();
            COSStream cOSStream = this.doSubset(subsetFontName);
            return cOSStream;
        }
        catch (Exception e) {
            LOG.error("Unable to subset font " + existingFontName, (Throwable)e);
        }
        return null;
    }

    public TrueTypeFont getFont() throws IOException {
        if (Objects.isNull(this.font)) {
            this.font = new TTFParser(true, true).parse(this.fontFileStream.getUnfilteredStream());
        }
        return this.font;
    }

    public SortedSet<Integer> getGlyphIds() {
        return Collections.unmodifiableSortedSet(this.glyphIds);
    }

    public abstract COSStream doSubset(String var1) throws IOException;

    public void setNumberOfGlyphs(int numberOfGlyphs) {
        this.numberOfGlyphs = numberOfGlyphs;
    }

    protected void updateChecksum(DataOutputStream out, Map<String, byte[]> tables) throws IOException {
        long checksum = this.writeFileHeader(out, tables.size());
        long offset = 12L + 16L * (long)tables.size();
        for (Map.Entry<String, byte[]> entry : tables.entrySet()) {
            checksum += this.writeTableHeader(out, entry.getKey(), offset, entry.getValue());
            offset += (long)((entry.getValue().length + 3) / 4 * 4);
        }
        checksum = 2981146554L - (checksum & 0xFFFFFFFFL);
        byte[] head = tables.get("head");
        head[8] = (byte)(checksum >>> 24);
        head[9] = (byte)(checksum >>> 16);
        head[10] = (byte)(checksum >>> 8);
        head[11] = (byte)checksum;
    }

    private void addCompositeGlyphs() throws IOException {
        GlyphTable glyphTable = this.getFont().getGlyph();
        long[] offsets = this.getFont().getIndexToLocation().getOffsets();
        HashSet<Integer> toProcess = new HashSet<Integer>(this.glyphIds);
        while (!toProcess.isEmpty()) {
            HashSet<Integer> composite = new HashSet<Integer>();
            for (Integer glyphId : toProcess) {
                if (glyphId < offsets.length) {
                    int flags;
                    long offset = offsets[glyphId];
                    long length = offsets[glyphId + 1] - offset;
                    if (length < 0L) continue;
                    this.fontSource.position(offset + glyphTable.getOffset());
                    ByteBuffer glyphData = ByteBuffer.allocate((int)length);
                    this.fontSource.read(glyphData);
                    glyphData.flip();
                    if (!this.isComposite(glyphData)) continue;
                    int off = 10;
                    do {
                        flags = (glyphData.get(off) & 0xFF) << 8 | glyphData.get(off + 1) & 0xFF;
                        int ogid = (glyphData.get(off += 2) & 0xFF) << 8 | glyphData.get(off + 1) & 0xFF;
                        composite.add(ogid);
                        off += 2;
                        off = (flags & 1) != 0 ? (off += 4) : (off += 2);
                        if ((flags & 0x80) != 0) {
                            off += 8;
                            continue;
                        }
                        if ((flags & 0x40) != 0) {
                            off += 4;
                            continue;
                        }
                        if ((flags & 8) == 0) continue;
                        off += 2;
                    } while ((flags & 0x20) != 0);
                    continue;
                }
                LOG.warn("Ignored composite glyph element {}", (Object)glyphId);
            }
            this.glyphIds.addAll(composite);
            toProcess.clear();
            toProcess.addAll(composite);
        }
    }

    private boolean isComposite(ByteBuffer glyphData) {
        return glyphData.limit() >= 2 && glyphData.getShort() == -1;
    }

    protected byte[] buildHeadTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                HeaderTable h = this.getFont().getHeader();
                this.writeFixed(out, h.getVersion());
                this.writeFixed(out, h.getFontRevision());
                this.writeUint32(out, 0L);
                this.writeUint32(out, h.getMagicNumber());
                this.writeUint16(out, h.getFlags());
                this.writeUint16(out, h.getUnitsPerEm());
                this.writeLongDateTime(out, h.getCreated());
                this.writeLongDateTime(out, h.getModified());
                this.writeSInt16(out, h.getXMin());
                this.writeSInt16(out, h.getYMin());
                this.writeSInt16(out, h.getXMax());
                this.writeSInt16(out, h.getYMax());
                this.writeUint16(out, h.getMacStyle());
                this.writeUint16(out, h.getLowestRecPPEM());
                this.writeSInt16(out, h.getFontDirectionHint());
                this.writeSInt16(out, (short)1);
                this.writeSInt16(out, h.getGlyphDataFormat());
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildHheaTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                HorizontalHeaderTable h = this.getFont().getHorizontalHeader();
                this.writeFixed(out, h.getVersion());
                this.writeSInt16(out, h.getAscender());
                this.writeSInt16(out, h.getDescender());
                this.writeSInt16(out, h.getLineGap());
                this.writeUint16(out, h.getAdvanceWidthMax());
                this.writeSInt16(out, h.getMinLeftSideBearing());
                this.writeSInt16(out, h.getMinRightSideBearing());
                this.writeSInt16(out, h.getXMaxExtent());
                this.writeSInt16(out, h.getCaretSlopeRise());
                this.writeSInt16(out, h.getCaretSlopeRun());
                this.writeSInt16(out, h.getReserved1());
                this.writeSInt16(out, h.getReserved2());
                this.writeSInt16(out, h.getReserved3());
                this.writeSInt16(out, h.getReserved4());
                this.writeSInt16(out, h.getReserved5());
                this.writeSInt16(out, h.getMetricDataFormat());
                this.writeUint16(out, Math.min(h.getNumberOfHMetrics(), this.numberOfGlyphs + 1));
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildMaxpTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                MaximumProfileTable p = this.getFont().getMaximumProfile();
                this.writeFixed(out, 1.0);
                this.writeUint16(out, this.numberOfGlyphs + 1);
                this.writeUint16(out, p.getMaxPoints());
                this.writeUint16(out, p.getMaxContours());
                this.writeUint16(out, p.getMaxCompositePoints());
                this.writeUint16(out, p.getMaxCompositeContours());
                this.writeUint16(out, p.getMaxZones());
                this.writeUint16(out, p.getMaxTwilightPoints());
                this.writeUint16(out, p.getMaxStorage());
                this.writeUint16(out, p.getMaxFunctionDefs());
                this.writeUint16(out, p.getMaxInstructionDefs());
                this.writeUint16(out, p.getMaxStackElements());
                this.writeUint16(out, p.getMaxSizeOfInstructions());
                this.writeUint16(out, p.getMaxComponentElements());
                this.writeUint16(out, p.getMaxComponentDepth());
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildNameTable(String subsetFontName) throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                NamingTable name = this.getFont().getNaming();
                if (Objects.nonNull(name)) {
                    Map<Integer, byte[]> records = name.getNameRecords().stream().filter(this::shouldCopyNameRecord).collect(Collectors.toMap(NameRecord::getNameId, record -> record.getString().getBytes(StandardCharsets.UTF_16BE)));
                    records.put(0, "This is a subeset for internal PDF use".getBytes(StandardCharsets.UTF_16BE));
                    records.put(1, subsetFontName.getBytes(StandardCharsets.UTF_16BE));
                    records.remove(3);
                    records.put(4, subsetFontName.getBytes(StandardCharsets.UTF_16BE));
                    records.put(5, "Version 1.0".getBytes(StandardCharsets.UTF_16BE));
                    records.put(6, subsetFontName.getBytes(StandardCharsets.UTF_16BE));
                    this.writeUint16(out, 0);
                    this.writeUint16(out, records.size());
                    this.writeUint16(out, 6 + 12 * records.size());
                    int offset = 0;
                    for (Map.Entry<Integer, byte[]> nameRecord : records.entrySet()) {
                        this.writeUint16(out, 3);
                        this.writeUint16(out, 1);
                        this.writeUint16(out, 1033);
                        this.writeUint16(out, nameRecord.getKey());
                        this.writeUint16(out, nameRecord.getValue().length);
                        this.writeUint16(out, offset);
                        offset += nameRecord.getValue().length;
                    }
                    for (byte[] bytes : records.values()) {
                        out.write(bytes);
                    }
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    boolean shouldCopyNameRecord(NameRecord nr) {
        return nr.getPlatformId() == 3 && nr.getPlatformEncodingId() == 1 && nr.getLanguageId() == 1033 && nr.getNameId() >= 0 && nr.getNameId() < 7;
    }

    protected byte[] buildGlyfTable(long[] newOffsets) throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            GlyphTable glyphTable = this.getFont().getGlyph();
            long[] offsets = this.getFont().getIndexToLocation().getOffsets();
            long newOffset = 0L;
            for (int glyphId = 0; glyphId <= this.numberOfGlyphs + 1; ++glyphId) {
                newOffsets[glyphId] = newOffset;
                if (!this.glyphIds.contains(glyphId) || glyphId >= offsets.length) continue;
                long offset = offsets[glyphId];
                long length = offsets[glyphId + 1] - offset;
                if (length >= 0L) {
                    this.fontSource.position(offset + glyphTable.getOffset());
                    ByteBuffer glyphData = ByteBuffer.allocate((int)length);
                    this.fontSource.read(glyphData);
                    glyphData.flip();
                    bos.write(glyphData.array());
                    newOffset += (long)glyphData.limit();
                    continue;
                }
                LOG.warn("Ignored glyph {}, cannot find a valid offset", (Object)glyphId);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildLocaTable(long[] newOffsets) throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                for (long offset : newOffsets) {
                    this.writeUint32(out, offset);
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildHmtxTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            HorizontalHeaderTable h = this.getFont().getHorizontalHeader();
            HorizontalMetricsTable hm = this.getFont().getHorizontalMetrics();
            int lastgid = h.getNumberOfHMetrics() - 1;
            this.fontSource.position(hm.getOffset());
            for (int glyphId = 0; glyphId <= this.numberOfGlyphs; ++glyphId) {
                long offset;
                if (glyphId <= lastgid) {
                    offset = (long)glyphId * 4L;
                    this.copyBytes((OutputStream)bos, offset + hm.getOffset(), 4);
                    continue;
                }
                offset = (long)h.getNumberOfHMetrics() * 4L + (long)(glyphId - h.getNumberOfHMetrics()) * 2L;
                this.copyBytes((OutputStream)bos, offset + hm.getOffset(), 2);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildPostTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            PostScriptTable post = this.getFont().getPostScript();
            if (Objects.nonNull(post)) {
                try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                    this.writeFixed(out, 3.0);
                    this.writeFixed(out, post.getItalicAngle());
                    this.writeSInt16(out, post.getUnderlinePosition());
                    this.writeSInt16(out, post.getUnderlineThickness());
                    this.writeUint32(out, post.getIsFixedPitch());
                    this.writeUint32(out, post.getMinMemType42());
                    this.writeUint32(out, post.getMaxMemType42());
                    this.writeUint32(out, post.getMinMemType1());
                    this.writeUint32(out, post.getMaxMemType1());
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildOS2Table() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                OS2WindowsMetricsTable os2 = this.getFont().getOS2Windows();
                if (Objects.nonNull(os2)) {
                    this.writeUint16(out, os2.getVersion());
                    this.writeSInt16(out, os2.getAverageCharWidth());
                    this.writeUint16(out, os2.getWeightClass());
                    this.writeUint16(out, os2.getWidthClass());
                    this.writeSInt16(out, os2.getFsType());
                    this.writeSInt16(out, os2.getSubscriptXSize());
                    this.writeSInt16(out, os2.getSubscriptYSize());
                    this.writeSInt16(out, os2.getSubscriptXOffset());
                    this.writeSInt16(out, os2.getSubscriptYOffset());
                    this.writeSInt16(out, os2.getSuperscriptXSize());
                    this.writeSInt16(out, os2.getSuperscriptYSize());
                    this.writeSInt16(out, os2.getSuperscriptXOffset());
                    this.writeSInt16(out, os2.getSuperscriptYOffset());
                    this.writeSInt16(out, os2.getStrikeoutSize());
                    this.writeSInt16(out, os2.getStrikeoutPosition());
                    this.writeSInt16(out, (short)os2.getFamilyClass());
                    out.write(os2.getPanose());
                    this.writeUint32(out, 0L);
                    this.writeUint32(out, 0L);
                    this.writeUint32(out, 0L);
                    this.writeUint32(out, 0L);
                    out.write(os2.getAchVendId().getBytes(StandardCharsets.US_ASCII));
                    this.writeUint16(out, os2.getFsSelection());
                    this.writeUint16(out, this.codeToGIDLookup.firstKey());
                    this.writeUint16(out, this.codeToGIDLookup.lastKey());
                    this.writeUint16(out, os2.getTypoAscender());
                    this.writeUint16(out, os2.getTypoDescender());
                    this.writeUint16(out, os2.getTypoLineGap());
                    this.writeUint16(out, os2.getWinAscent());
                    this.writeUint16(out, os2.getWinDescent());
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    protected byte[] buildCMapTable() throws IOException {
        try (FastByteArrayOutputStream bos = new FastByteArrayOutputStream();){
            try (DataOutputStream out = new DataOutputStream((OutputStream)bos);){
                int i;
                Map.Entry<Integer, Integer> lastChar;
                this.writeUint16(out, 0);
                this.writeUint16(out, 1);
                this.writeUint16(out, 3);
                this.writeUint16(out, 1);
                this.writeUint32(out, 12L);
                Iterator<Map.Entry<Integer, Integer>> it = this.codeToGIDLookup.entrySet().iterator();
                Map.Entry<Integer, Integer> prevChar = lastChar = it.next();
                int lastGid = lastChar.getValue();
                int[] startCode = new int[this.codeToGIDLookup.size() + 1];
                int[] endCode = new int[startCode.length];
                int[] idDelta = new int[startCode.length];
                int segCount = 0;
                while (it.hasNext()) {
                    Map.Entry<Integer, Integer> curChar2Gid = it.next();
                    int curGid = curChar2Gid.getValue();
                    if (curChar2Gid.getKey() > 65535) {
                        throw new UnsupportedOperationException("non-BMP Unicode character");
                    }
                    if (curChar2Gid.getKey() != prevChar.getKey() + 1 || curGid - lastGid != curChar2Gid.getKey() - lastChar.getKey()) {
                        if (lastGid != 0) {
                            startCode[segCount] = lastChar.getKey();
                            endCode[segCount] = prevChar.getKey();
                            idDelta[segCount] = lastGid - lastChar.getKey();
                            ++segCount;
                        } else if (!lastChar.getKey().equals(prevChar.getKey())) {
                            startCode[segCount] = lastChar.getKey() + 1;
                            endCode[segCount] = prevChar.getKey();
                            idDelta[segCount] = lastGid - lastChar.getKey();
                            ++segCount;
                        }
                        lastGid = curGid;
                        lastChar = curChar2Gid;
                    }
                    prevChar = curChar2Gid;
                }
                startCode[segCount] = lastChar.getKey();
                endCode[segCount] = prevChar.getKey();
                idDelta[segCount] = lastGid - lastChar.getKey();
                startCode[++segCount] = 65535;
                endCode[segCount] = 65535;
                idDelta[segCount] = 1;
                int searchRange = 2 * (int)Math.pow(2.0, this.log2(++segCount));
                this.writeUint16(out, 4);
                this.writeUint16(out, 16 + segCount * 4 * 2);
                this.writeUint16(out, 0);
                this.writeUint16(out, segCount * 2);
                this.writeUint16(out, searchRange);
                this.writeUint16(out, this.log2(searchRange / 2));
                this.writeUint16(out, 2 * segCount - searchRange);
                for (i = 0; i < segCount; ++i) {
                    this.writeUint16(out, endCode[i]);
                }
                this.writeUint16(out, 0);
                for (i = 0; i < segCount; ++i) {
                    this.writeUint16(out, startCode[i]);
                }
                for (i = 0; i < segCount; ++i) {
                    this.writeUint16(out, idDelta[i]);
                }
                for (i = 0; i < segCount; ++i) {
                    this.writeUint16(out, 0);
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    private void copyBytes(OutputStream os, long offset, int count) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(count);
        this.fontSource.position(offset);
        this.fontSource.read(data);
        data.flip();
        os.write(data.array());
    }

    private void writeFixed(DataOutputStream out, double f) throws IOException {
        double ip = Math.floor(f);
        double fp = (f - ip) * 65536.0;
        out.writeShort((int)ip);
        out.writeShort((int)fp);
    }

    private void writeUint32(DataOutputStream out, long l) throws IOException {
        out.writeInt((int)l);
    }

    private void writeUint16(DataOutputStream out, int i) throws IOException {
        out.writeShort(i);
    }

    private void writeSInt16(DataOutputStream out, short i) throws IOException {
        out.writeShort(i);
    }

    private void writeLongDateTime(DataOutputStream out, Calendar calendar) throws IOException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1904, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        long millisFor1904 = cal.getTimeInMillis();
        long secondsSince1904 = (calendar.getTimeInMillis() - millisFor1904) / 1000L;
        out.writeLong(secondsSince1904);
    }

    private long writeFileHeader(DataOutputStream out, int nTables) throws IOException {
        out.writeInt(65536);
        out.writeShort(nTables);
        int mask = Integer.highestOneBit(nTables);
        int searchRange = mask * 16;
        out.writeShort(searchRange);
        int entrySelector = this.log2(mask);
        out.writeShort(entrySelector);
        int last = 16 * nTables - searchRange;
        out.writeShort(last);
        return 65536L + this.toUInt32(nTables, searchRange) + this.toUInt32(entrySelector, last);
    }

    private long writeTableHeader(DataOutputStream out, String tag, long offset, byte[] bytes) throws IOException {
        long checksum = 0L;
        int n = bytes.length;
        for (int nup = 0; nup < n; ++nup) {
            checksum += ((long)bytes[nup] & 0xFFL) << 24 - nup % 4 * 8;
        }
        byte[] tagbytes = tag.getBytes(StandardCharsets.US_ASCII);
        out.write(tagbytes, 0, 4);
        out.writeInt((int)(checksum &= 0xFFFFFFFFL));
        out.writeInt((int)offset);
        out.writeInt(bytes.length);
        return this.toUInt32(tagbytes) + checksum + checksum + offset + (long)bytes.length;
    }

    public void writeTableBody(OutputStream os, byte[] bytes) throws IOException {
        int n = bytes.length;
        os.write(bytes);
        if (n % 4 != 0) {
            os.write(PAD_BUF, 0, 4 - n % 4);
        }
    }

    private long toUInt32(int high, int low) {
        return ((long)high & 0xFFFFL) << 16 | (long)low & 0xFFFFL;
    }

    private long toUInt32(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
    }

    private int log2(int num) {
        return (int)Math.floor(Math.log(num) / Math.log(2.0));
    }
}

