/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.DecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.MessageDigests;
import org.sejda.sambox.pdmodel.encryption.PDCryptFilterDictionary;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;

public final class PublicKeySecurityHandler
extends SecurityHandler {
    public static final String FILTER = "Adobe.PubSec";
    private PublicKeyProtectionPolicy policy = null;

    public PublicKeySecurityHandler() {
    }

    public PublicKeySecurityHandler(PublicKeyProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    @Override
    public void prepareForDecryption(PDEncryption encryption, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws IOException {
        if (!(decryptionMaterial instanceof PublicKeyDecryptionMaterial)) {
            throw new IOException("Provided decryption material is not compatible with the document");
        }
        PublicKeyDecryptionMaterial material = (PublicKeyDecryptionMaterial)decryptionMaterial;
        PDCryptFilterDictionary defaultCryptFilterDictionary = encryption.getDefaultCryptFilterDictionary();
        if (defaultCryptFilterDictionary != null && defaultCryptFilterDictionary.getLength() != 0) {
            this.setKeyLength(defaultCryptFilterDictionary.getLength());
            this.setDecryptMetadata(defaultCryptFilterDictionary.isEncryptMetaData());
        } else if (encryption.getLength() != 0) {
            this.setKeyLength(encryption.getLength());
            this.setDecryptMetadata(encryption.isEncryptMetaData());
        }
        try {
            byte[] mdResult;
            boolean foundRecipient = false;
            X509Certificate certificate = material.getCertificate();
            X509CertificateHolder materialCert = null;
            if (certificate != null) {
                materialCert = new X509CertificateHolder(certificate.getEncoded());
            }
            byte[] envelopedData = null;
            COSArray array = encryption.getCOSObject().getCOSArray(COSName.RECIPIENTS);
            if (array == null && defaultCryptFilterDictionary != null) {
                array = defaultCryptFilterDictionary.getCOSObject().getCOSArray(COSName.RECIPIENTS);
            }
            if (array == null) {
                throw new IOException("/Recipients entry is missing in encryption dictionary");
            }
            byte[][] recipientFieldsBytes = new byte[array.size()][];
            int recipientFieldsLength = 0;
            StringBuilder extraInfo = new StringBuilder();
            for (int i = 0; i < array.size(); ++i) {
                COSString recipientFieldString = (COSString)array.getObject(i);
                byte[] recipientBytes = recipientFieldString.getBytes();
                CMSEnvelopedData data = new CMSEnvelopedData(recipientBytes);
                Collection recipCertificatesIt = data.getRecipientInfos().getRecipients();
                int j = 0;
                Iterator iterator = recipCertificatesIt.iterator();
                while (iterator.hasNext()) {
                    RecipientInformation ri = (RecipientInformation)iterator.next();
                    RecipientId rid = ri.getRID();
                    if (!foundRecipient && rid.match((Object)materialCert)) {
                        foundRecipient = true;
                        PrivateKey privateKey = (PrivateKey)material.getPrivateKey();
                        envelopedData = ri.getContent((Recipient)new JceKeyTransEnvelopedRecipient(privateKey));
                        break;
                    }
                    ++j;
                    if (certificate == null) continue;
                    extraInfo.append('\n');
                    extraInfo.append(j);
                    extraInfo.append(": ");
                    if (!(rid instanceof KeyTransRecipientId)) continue;
                    this.appendCertInfo(extraInfo, (KeyTransRecipientId)rid, certificate, materialCert);
                }
                recipientFieldsBytes[i] = recipientBytes;
                recipientFieldsLength += recipientBytes.length;
            }
            if (!foundRecipient || envelopedData == null) {
                throw new IOException("The certificate matches none of " + array.size() + " recipient entries" + extraInfo);
            }
            if (envelopedData.length != 24) {
                throw new IOException("The enveloped data does not contain 24 bytes");
            }
            byte[] accessBytes = new byte[4];
            System.arraycopy(envelopedData, 20, accessBytes, 0, 4);
            AccessPermission currentAccessPermission = new AccessPermission(accessBytes);
            currentAccessPermission.setReadOnly();
            this.setCurrentAccessPermission(currentAccessPermission);
            byte[] sha1Input = new byte[recipientFieldsLength + 20];
            System.arraycopy(envelopedData, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (Object recipientFieldsByte : (Collection)recipientFieldsBytes) {
                System.arraycopy(recipientFieldsByte, 0, sha1Input, sha1InputOffset, ((Object)recipientFieldsByte).length);
                sha1InputOffset += ((Object)recipientFieldsByte).length;
            }
            if (encryption.getVersion() == 4 || encryption.getVersion() == 5) {
                if (!this.isDecryptMetadata()) {
                    sha1Input = Arrays.copyOf(sha1Input, sha1Input.length + 4);
                    System.arraycopy(new byte[]{-1, -1, -1, -1}, 0, sha1Input, sha1Input.length - 4, 4);
                }
                mdResult = encryption.getVersion() == 4 ? MessageDigests.getSHA1().digest(sha1Input) : MessageDigests.getSHA256().digest(sha1Input);
                if (defaultCryptFilterDictionary != null) {
                    COSName cryptFilterMethod = defaultCryptFilterDictionary.getCryptFilterMethod();
                    this.setAES(COSName.AESV2.equals(cryptFilterMethod) || COSName.AESV3.equals(cryptFilterMethod));
                }
            } else {
                mdResult = MessageDigests.getSHA1().digest(sha1Input);
            }
            this.setEncryptionKey(new byte[this.keyLength / 8]);
            System.arraycopy(mdResult, 0, this.getEncryptionKey(), 0, this.keyLength / 8);
        }
        catch (KeyStoreException | CertificateEncodingException | CMSException e) {
            throw new IOException(e);
        }
    }

    private void appendCertInfo(StringBuilder extraInfo, KeyTransRecipientId ktRid, X509Certificate certificate, X509CertificateHolder materialCert) {
        BigInteger ridSerialNumber = ktRid.getSerialNumber();
        if (ridSerialNumber != null) {
            String certSerial = "unknown";
            BigInteger certSerialNumber = certificate.getSerialNumber();
            if (certSerialNumber != null) {
                certSerial = certSerialNumber.toString(16);
            }
            extraInfo.append("serial-#: rid ");
            extraInfo.append(ridSerialNumber.toString(16));
            extraInfo.append(" vs. cert ");
            extraInfo.append(certSerial);
            extraInfo.append(" issuer: rid '");
            extraInfo.append(ktRid.getIssuer());
            extraInfo.append("' vs. cert '");
            extraInfo.append((Object)(materialCert == null ? "null" : materialCert.getIssuer()));
            extraInfo.append("' ");
        }
    }
}

