/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.InvalidNumberOfPagesException;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PageNotFoundException;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.util.ObjectIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDPageTree
implements COSObjectable,
Iterable<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(PDPageTree.class);
    private final COSDictionary root;
    private final PDDocument document;

    public PDPageTree() {
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        this.root.setItem(COSName.KIDS, (COSBase)new COSArray());
        this.root.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
        this.document = null;
    }

    public PDPageTree(COSDictionary root) {
        this(root, null);
    }

    PDPageTree(COSDictionary root, PDDocument document) {
        RequireUtils.requireNotNullArg((Object)root, (String)"Page tree root cannot be null");
        if (COSName.PAGE.equals(root.getCOSName(COSName.TYPE))) {
            COSArray kids = new COSArray();
            kids.add(root);
            this.root = new COSDictionary();
            this.root.setItem(COSName.KIDS, (COSBase)kids);
            this.root.setInt(COSName.COUNT, 1);
        } else {
            this.root = root;
        }
        root.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        this.document = document;
    }

    public static <T extends COSBase> COSBase getInheritableAttribute(COSDictionary node, COSName key, Class<T> clazz) {
        COSBase result = PDPageTree.getInheritableAttribute(node, key);
        if (clazz.isInstance(result)) {
            return result;
        }
        return null;
    }

    public static COSBase getInheritableAttribute(COSDictionary node, COSName key) {
        return PDPageTree.getInheritableAttribute(node, key, new HashSet<String>());
    }

    public static COSBase getInheritableAttribute(COSDictionary node, COSName key, Set<String> visitedObjectIds) {
        COSBase value = node.getDictionaryObject(key);
        if (value != null) {
            return value;
        }
        COSDictionary parent = node.getDictionaryObject(COSName.PARENT, COSName.P, COSDictionary.class);
        if (parent == node) {
            return null;
        }
        if (parent != null) {
            String objId = ObjectIdUtils.getObjectIdOf(node);
            if (!objId.isBlank() && visitedObjectIds.contains(objId)) {
                return null;
            }
            visitedObjectIds.add(objId);
            return PDPageTree.getInheritableAttribute(parent, key, visitedObjectIds);
        }
        return null;
    }

    @Override
    public Iterator<PDPage> iterator() {
        PageIterator iterator = new PageIterator(this.root);
        if (iterator.size() != this.document.getNumberOfPages()) {
            for (int i = 0; i < this.document.getNumberOfPages(); ++i) {
                this.get(i);
            }
            throw new InvalidNumberOfPagesException(iterator.size(), this.document.getNumberOfPages());
        }
        return iterator;
    }

    public Stream<PDPage> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), (long)this.getCount(), 272), false);
    }

    public Stream<COSDictionary> streamNodes() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new NodesIterator(this.root), 272), false);
    }

    private List<COSDictionary> getKids(COSDictionary node) {
        COSArray kids = node.getDictionaryObject(COSName.KIDS, COSArray.class);
        if (Objects.nonNull(kids)) {
            return kids.stream().map(COSBase::getCOSObject).filter(i -> i != COSNull.NULL).filter(Objects::nonNull).filter(n -> n instanceof COSDictionary).map(n -> (COSDictionary)n).collect(Collectors.toList());
        }
        return new ArrayList<COSDictionary>();
    }

    public PDPage get(int index) {
        PageAndPageTreeParent res = this.get(index + 1, this.root, 0, null, new HashSet<COSDictionary>());
        COSDictionary dict = res.node;
        PDPageTree.sanitizeType(dict);
        ResourceCache resourceCache = this.document != null ? this.document.getResourceCache() : null;
        return new PDPage(dict, resourceCache, res.parent);
    }

    private static void sanitizeType(COSDictionary dictionary) {
        COSName type;
        if (Objects.isNull(dictionary.getCOSName(COSName.TYPE))) {
            LOG.warn("Missing required 'Page' type for page");
            dictionary.setName(COSName.TYPE, COSName.PAGE.getName());
        }
        if (!COSName.PAGE.equals(type = dictionary.getCOSName(COSName.TYPE))) {
            LOG.error("Expected 'Page' but found '{}'", (Object)type.getName());
            dictionary.setName(COSName.TYPE, COSName.PAGE.getName());
        }
    }

    private PageAndPageTreeParent get(int pageNum, COSDictionary node, int encountered, COSDictionary pageTreeParent, Set<COSDictionary> visited) {
        RequireUtils.require((pageNum >= 0 ? 1 : 0) != 0, () -> new PageNotFoundException("Index out of bounds: " + pageNum + " in " + this.getSourcePath(), pageNum, this.getSourcePath()));
        RequireUtils.require((boolean)visited.add(node), () -> new IllegalStateException("Possible recursion found when searching for page " + pageNum));
        if (PDPageTree.isPageTreeNode(node)) {
            int count = node.getInt(COSName.COUNT, 0);
            if (pageNum <= encountered + count) {
                for (COSDictionary kid : this.getKids(node)) {
                    if (PDPageTree.isPageTreeNode(kid)) {
                        int kidCount = kid.getInt(COSName.COUNT, 0);
                        if (pageNum <= encountered + kidCount) {
                            return this.get(pageNum, kid, encountered, node, visited);
                        }
                        encountered += kidCount;
                        continue;
                    }
                    if (pageNum != ++encountered) continue;
                    return this.get(pageNum, kid, encountered, node, visited);
                }
                throw new PageNotFoundException("Unable to find page " + pageNum + " in " + this.getSourcePath(), pageNum, this.getSourcePath());
            }
            throw new PageNotFoundException("Index out of bounds: " + pageNum + " in " + this.getSourcePath(), pageNum, this.getSourcePath());
        }
        if (encountered == pageNum) {
            return new PageAndPageTreeParent(node, pageTreeParent);
        }
        throw new PageNotFoundException("Unable to find page " + pageNum + " in " + this.getSourcePath(), pageNum, this.getSourcePath());
    }

    private String getSourcePath() {
        return Optional.ofNullable(this.getCOSObject().id()).map(i -> i.ownerIdentifier).orElse("Unknown");
    }

    public static boolean isPageTreeNode(COSDictionary node) {
        return Objects.nonNull(node) && (node.getCOSName(COSName.TYPE) == COSName.PAGES || node.containsKey(COSName.KIDS));
    }

    public int indexOf(PDPage page) {
        SearchContext context = new SearchContext(page);
        if (this.findPage(context, this.root)) {
            return context.index;
        }
        return -1;
    }

    private boolean findPage(SearchContext context, COSDictionary node) {
        for (COSDictionary kid : this.getKids(node)) {
            if (context.found) break;
            if (PDPageTree.isPageTreeNode(kid)) {
                this.findPage(context, kid);
                continue;
            }
            context.visitPage(kid);
        }
        return context.found;
    }

    public int getCount() {
        return this.root.getInt(COSName.COUNT, 0);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.root;
    }

    public void remove(int index) {
        PageAndPageTreeParent res = this.get(index + 1, this.root, 0, null, new HashSet<COSDictionary>());
        this.remove(res.node, res.parent);
    }

    public void remove(PDPage page) {
        this.remove(page.getCOSObject());
    }

    private void remove(COSDictionary node) {
        this.remove(node, null);
    }

    private void remove(COSDictionary node, COSDictionary knownParent) {
        COSArray kids;
        COSDictionary parent = node.getDictionaryObject(COSName.PARENT, COSName.P, COSDictionary.class);
        if (parent == null) {
            parent = knownParent;
        }
        if ((kids = parent.getDictionaryObject(COSName.KIDS, COSArray.class)).removeObject(node)) {
            parent.setInt(COSName.COUNT, parent.getInt(COSName.COUNT) - 1);
            node = parent;
            do {
                if ((node = node.getDictionaryObject(COSName.PARENT, COSName.P, COSDictionary.class)) == null) continue;
                node.setInt(COSName.COUNT, node.getInt(COSName.COUNT) - 1);
            } while (node != null);
        }
    }

    public void add(PDPage page) {
        COSDictionary node = page.getCOSObject();
        node.setItem(COSName.PARENT, (COSBase)this.root);
        COSArray kids = this.root.getDictionaryObject(COSName.KIDS, COSArray.class);
        kids.add(node);
        do {
            if ((node = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P)) == null) continue;
            node.setInt(COSName.COUNT, node.getInt(COSName.COUNT) + 1);
        } while (node != null);
    }

    public void insertBefore(PDPage newPage, PDPage nextPage) {
        COSDictionary nextPageDict = nextPage.getCOSObject();
        COSDictionary parentDict = nextPageDict.getDictionaryObject(COSName.PARENT, COSDictionary.class);
        if (nextPage.getPageTreeParent() != null) {
            parentDict = nextPage.getPageTreeParent();
        }
        COSArray kids = parentDict.getDictionaryObject(COSName.KIDS, COSArray.class);
        boolean found = false;
        for (int i = 0; i < kids.size(); ++i) {
            COSDictionary pageDict = (COSDictionary)kids.getObject(i);
            if (!pageDict.equals(nextPage.getCOSObject())) continue;
            kids.add(i, newPage.getCOSObject());
            newPage.getCOSObject().setItem(COSName.PARENT, (COSBase)parentDict);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("attempted to insert before orphan page");
        }
        this.increaseParents(parentDict);
    }

    public void insertAfter(PDPage newPage, PDPage prevPage) {
        COSDictionary prevPageDict = prevPage.getCOSObject();
        COSDictionary parentDict = prevPageDict.getDictionaryObject(COSName.PARENT, COSDictionary.class);
        if (prevPage.getPageTreeParent() != null) {
            parentDict = prevPage.getPageTreeParent();
        }
        COSArray kids = parentDict.getDictionaryObject(COSName.KIDS, COSArray.class);
        boolean found = false;
        for (int i = 0; i < kids.size(); ++i) {
            COSDictionary pageDict = (COSDictionary)kids.getObject(i);
            if (!pageDict.equals(prevPage.getCOSObject())) continue;
            kids.add(i + 1, newPage.getCOSObject());
            newPage.getCOSObject().setItem(COSName.PARENT, (COSBase)parentDict);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("attempted to insert before orphan page");
        }
        this.increaseParents(parentDict);
    }

    private void increaseParents(COSDictionary parentDict) {
        do {
            int cnt = parentDict.getInt(COSName.COUNT);
            parentDict.setInt(COSName.COUNT, cnt + 1);
        } while ((parentDict = (COSDictionary)parentDict.getDictionaryObject(COSName.PARENT)) != null);
    }

    private final class PageIterator
    implements Iterator<PDPage> {
        private final Queue<COSDictionary> queue = new ArrayDeque<COSDictionary>();

        private PageIterator(COSDictionary node) {
            this.enqueueKids(node);
        }

        private void enqueueKids(COSDictionary node) {
            if (PDPageTree.isPageTreeNode(node)) {
                PDPageTree.this.getKids(node).forEach(this::enqueueKids);
            } else {
                this.queue.add(node);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public PDPage next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            COSDictionary next = this.queue.poll();
            PDPageTree.sanitizeType(next);
            ResourceCache resourceCache = PDPageTree.this.document != null ? PDPageTree.this.document.getResourceCache() : null;
            return new PDPage(next, resourceCache);
        }

        public int size() {
            return this.queue.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class NodesIterator
    implements Iterator<COSDictionary> {
        private final Queue<COSDictionary> queue = new ArrayDeque<COSDictionary>();

        private NodesIterator(COSDictionary node) {
            this.enqueueKids(node);
        }

        private void enqueueKids(COSDictionary node) {
            this.queue.add(node);
            if (PDPageTree.isPageTreeNode(node)) {
                PDPageTree.this.getKids(node).forEach(this::enqueueKids);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public COSDictionary next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.queue.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PageAndPageTreeParent {
        public final COSDictionary node;
        public final COSDictionary parent;

        public PageAndPageTreeParent(COSDictionary node, COSDictionary parent) {
            this.node = node;
            this.parent = parent;
        }
    }

    private static final class SearchContext {
        private final COSDictionary searched;
        private int index = -1;
        private boolean found;

        private SearchContext(PDPage page) {
            this.searched = page.getCOSObject();
        }

        private void visitPage(COSDictionary current) {
            ++this.index;
            this.found = this.searched.equals(current);
        }
    }
}

