/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.xref.FileTrailer;

public class COSDocument
extends COSBase {
    private String headerVersion;
    private final FileTrailer trailer;

    public COSDocument() {
        this(new FileTrailer(), "1.4");
        COSDictionary catalog = new COSDictionary();
        catalog.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        this.trailer.getCOSObject().setItem(COSName.ROOT, (COSBase)catalog);
    }

    public COSDocument(FileTrailer trailer, String headerVersion) {
        RequireUtils.requireNotNullArg((Object)trailer, (String)"Trailer cannot be null");
        RequireUtils.requireNotBlank((String)headerVersion, (String)"Header version cannot be blank");
        this.trailer = trailer;
        this.headerVersion = headerVersion;
        Optional.ofNullable(this.trailer.getCOSObject().getDictionaryObject(COSName.ROOT, COSDictionary.class)).ifPresent(d -> d.setItem(COSName.TYPE, (COSBase)COSName.CATALOG));
    }

    public void setHeaderVersion(String headerVersion) {
        RequireUtils.requireNotBlank((String)headerVersion, (String)"Header version cannot be null");
        this.headerVersion = headerVersion;
    }

    public String getHeaderVersion() {
        return this.headerVersion;
    }

    public boolean isEncrypted() {
        return Objects.nonNull(this.trailer.getCOSObject().getDictionaryObject(COSName.ENCRYPT, COSDictionary.class));
    }

    public COSDictionary getEncryptionDictionary() {
        return this.trailer.getCOSObject().getDictionaryObject(COSName.ENCRYPT, COSDictionary.class);
    }

    public void setEncryptionDictionary(COSDictionary dictionary) {
        this.trailer.getCOSObject().setItem(COSName.ENCRYPT, (COSBase)dictionary);
    }

    public COSArray getDocumentID() {
        return this.trailer.getCOSObject().getDictionaryObject(COSName.ID, COSArray.class);
    }

    public void setDocumentID(COSArray id) {
        this.trailer.getCOSObject().setItem(COSName.ID, (COSBase)id);
    }

    public COSDictionary getCatalog() {
        return Optional.ofNullable(this.trailer.getCOSObject().getDictionaryObject(COSName.ROOT, COSDictionary.class)).orElseThrow(() -> new IllegalStateException("Catalog cannot be found"));
    }

    public FileTrailer getTrailer() {
        return this.trailer;
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

