/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.ui;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.StructuredTaskScope;
import org.pdfsam.core.context.ApplicationContext;
import org.pdfsam.eventstudio.StaticStudio;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.injector.Auto;
import org.pdfsam.model.tool.Tool;
import org.pdfsam.model.ui.workspace.LoadWorkspaceRequest;
import org.pdfsam.model.ui.workspace.LoadWorkspaceResponse;
import org.pdfsam.model.ui.workspace.SaveWorkspaceRequest;
import org.pdfsam.model.ui.workspace.WorkspaceLoadedEvent;
import org.pdfsam.service.ui.RecentWorkspacesService;
import org.pdfsam.service.ui.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class WorkspaceController {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceController.class);
    private final Collection<Tool> tools;
    private final WorkspaceService service;
    private final RecentWorkspacesService recentWorkspace;

    @Inject
    WorkspaceController(WorkspaceService service, RecentWorkspacesService recentWorkspace) {
        this(ApplicationContext.app().runtimeState().tools().values(), service, recentWorkspace);
    }

    WorkspaceController(Collection<Tool> tools, WorkspaceService service, RecentWorkspacesService recentWorkspace) {
        this.tools = tools;
        this.service = service;
        this.recentWorkspace = recentWorkspace;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void saveWorkspace(SaveWorkspaceRequest event) {
        Thread.ofVirtual().name("save-workspace-thread").start(() -> {
            try (StructuredTaskScope.ShutdownOnFailure scope = new StructuredTaskScope.ShutdownOnFailure();){
                LOG.debug(I18nContext.i18n().tr("Requesting modules state"));
                this.tools.forEach(m -> scope.fork(() -> {
                    StaticStudio.eventStudio().broadcast((Object)event, m.id());
                    return null;
                }));
                scope.join();
                scope.throwIfFailed();
                this.service.saveWorkspace(event.data(), event.workspace());
            }
            catch (Exception e) {
                LOG.error(I18nContext.i18n().tr("Unable to save workspace to {0}", new String[]{event.workspace().getName()}), (Throwable)e);
            }
        });
    }

    @EventListener
    public void loadWorkspace(LoadWorkspaceRequest event) {
        Thread.ofVirtual().name("load-workspace-thread").start(() -> {
            LOG.debug(I18nContext.i18n().tr("Loading workspace from {0}", new String[]{event.workspace().getName()}));
            try (StructuredTaskScope.ShutdownOnFailure scope = new StructuredTaskScope.ShutdownOnFailure();){
                Map<String, Map<String, String>> data = this.service.loadWorkspace(event.workspace());
                if (!data.isEmpty()) {
                    LoadWorkspaceResponse response = new LoadWorkspaceResponse(event.workspace(), data);
                    this.tools.forEach(m -> scope.fork(() -> {
                        StaticStudio.eventStudio().broadcast((Object)response, m.id());
                        return null;
                    }));
                    scope.join();
                    scope.throwIfFailed();
                    this.recentWorkspace.addWorkspaceLastUsed(event.workspace());
                    StaticStudio.eventStudio().broadcast((Object)new WorkspaceLoadedEvent(event.workspace()));
                    LOG.info(I18nContext.i18n().tr("Workspace loaded: {0}", new String[]{event.workspace().getName()}));
                }
            }
            catch (Exception e) {
                LOG.error(I18nContext.i18n().tr("Unable to load workspace from {0}", new String[]{event.workspace().getName()}), (Throwable)e);
            }
        });
    }
}

