/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.service.pdf;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javafx.application.Platform;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.model.pdf.PdfDocumentDescriptor;
import org.pdfsam.model.tool.RequiredPdfData;
import org.pdfsam.service.pdf.PdfLoadService;
import org.pdfsam.service.pdf.PdfLoader;
import org.sejda.io.BufferedSeekableSource;
import org.sejda.io.FileChannelSeekableSource;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.InvalidPasswordException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPdfLoadService
implements PdfLoadService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPdfLoadService.class);
    private final Map<RequiredPdfData, BiConsumer<PDDocument, PdfDocumentDescriptor>> consumers = new HashMap<RequiredPdfData, BiConsumer<PDDocument, PdfDocumentDescriptor>>();
    private static final BiConsumer<PDDocument, PdfDocumentDescriptor> STARTER = (r, descriptor) -> {};
    private static final BiConsumer<PDDocument, PdfDocumentDescriptor> FINISHER = (r, descriptor) -> {
        if (descriptor.hasPassword()) {
            DefaultPdfLoadService.fxMoveStatusTo(descriptor, PdfDescriptorLoadingStatus.LOADED_WITH_USER_PWD_DECRYPTION);
        } else {
            DefaultPdfLoadService.fxMoveStatusTo(descriptor, PdfDescriptorLoadingStatus.LOADED);
        }
    };

    public DefaultPdfLoadService(List<PdfLoader<PDDocument>> loaders) {
        loaders.forEach(l -> this.consumers.put(l.key(), (BiConsumer<PDDocument, PdfDocumentDescriptor>)l));
    }

    @Override
    public void load(Collection<? extends PdfDocumentDescriptor> toLoad, RequiredPdfData ... requires) {
        LOG.debug(I18nContext.i18n().tr("Loading pdf documents"));
        BiConsumer<PDDocument, PdfDocumentDescriptor> consumer = Arrays.stream(requires).map(this.consumers::get).reduce(STARTER, BiConsumer::andThen).andThen(FINISHER);
        for (PdfDocumentDescriptor pdfDocumentDescriptor : toLoad) {
            if (pdfDocumentDescriptor.hasReferences()) {
                LOG.trace("Loading {}", (Object)pdfDocumentDescriptor.getFileName());
                DefaultPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.LOADING);
                try (PDDocument document = PDFParser.parse((SeekableSource)new BufferedSeekableSource((SeekableSource)new FileChannelSeekableSource(pdfDocumentDescriptor.getFile())), (String)pdfDocumentDescriptor.getPassword());){
                    consumer.accept(document, pdfDocumentDescriptor);
                }
                catch (InvalidPasswordException twpe) {
                    DefaultPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.ENCRYPTED);
                    LOG.warn("User password required for '{}'", (Object)pdfDocumentDescriptor.getFileName(), (Object)twpe);
                }
                catch (Exception e) {
                    LOG.error("An error occurred loading the document '{}'", (Object)pdfDocumentDescriptor.getFileName(), (Object)e);
                    DefaultPdfLoadService.fxMoveStatusTo(pdfDocumentDescriptor, PdfDescriptorLoadingStatus.WITH_ERRORS);
                }
                LOG.info("{} loaded", (Object)pdfDocumentDescriptor.getFileName());
                continue;
            }
            LOG.trace("Skipping invalidated document {}", (Object)pdfDocumentDescriptor.getFileName());
        }
        LOG.debug(I18nContext.i18n().tr("Documents loaded"));
    }

    private static void fxMoveStatusTo(PdfDocumentDescriptor descriptor, PdfDescriptorLoadingStatus status) {
        Platform.runLater(() -> descriptor.moveStatusTo(status));
    }
}

