/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.tool;

import org.pdfsam.model.tool.ToolCategory;
import org.pdfsam.model.tool.ToolDescriptor;
import org.pdfsam.model.tool.ToolInputOutputType;
import org.pdfsam.model.tool.ToolPriority;

public final class ToolDescriptorBuilder {
    private ToolCategory category;
    private ToolInputOutputType[] inputTypes;
    private String name;
    private String description;
    private int priority = ToolPriority.DEFAULT.getPriority();
    private String supportURL;

    private ToolDescriptorBuilder() {
    }

    public ToolDescriptorBuilder category(ToolCategory category) {
        this.category = category;
        return this;
    }

    public ToolDescriptorBuilder inputTypes(ToolInputOutputType ... inputTypes) {
        this.inputTypes = inputTypes;
        return this;
    }

    public ToolDescriptorBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ToolDescriptorBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ToolDescriptorBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ToolDescriptorBuilder priority(ToolPriority priority) {
        this.priority = priority.getPriority();
        return this;
    }

    public ToolDescriptorBuilder supportURL(String supportURL) {
        this.supportURL = supportURL;
        return this;
    }

    public static ToolDescriptorBuilder builder() {
        return new ToolDescriptorBuilder();
    }

    public ToolDescriptor build() {
        return new ToolDescriptor(this.category, this.name, this.description, this.priority, this.supportURL, this.inputTypes);
    }
}

