/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.model.task;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.sejda.commons.collection.NullSafeSet;
import org.sejda.model.input.PdfSource;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.pdf.page.PredefinedSetOfPages;
import org.sejda.model.rotation.Rotation;

public class PdfRotationInput
implements PagesSelection {
    @Valid
    @NotNull
    public final PdfSource<?> source;
    @Valid
    @NotNull
    public final Rotation rotation;
    @Valid
    @NotEmpty
    private final Set<PagesSelection> pageSelection = new NullSafeSet();

    public PdfRotationInput(PdfSource<?> source, Rotation rotation, PagesSelection ... pages) {
        Objects.requireNonNull(rotation, "A rotation is expected");
        Objects.requireNonNull(source, "A valid source is expected");
        this.source = source;
        this.rotation = rotation;
        this.pageSelection.addAll(Optional.ofNullable(pages).filter(p -> ((PagesSelection[])p).length > 0).map(Arrays::asList).orElseGet(() -> List.of(PredefinedSetOfPages.ALL_PAGES)));
    }

    public Set<Integer> getPages(int totalNumberOfPage) {
        NullSafeSet set = new NullSafeSet();
        this.pageSelection.stream().flatMap(s -> s.getPages(totalNumberOfPage).stream()).forEach(((Set)set)::add);
        return set;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("source", this.source).append("pageSelection", this.pageSelection).append("rotation", (Object)this.rotation).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.source).append(this.pageSelection).append((Object)this.rotation).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PdfRotationInput)) {
            return false;
        }
        PdfRotationInput input = (PdfRotationInput)other;
        return new EqualsBuilder().append(this.source, input.source).append((Object)this.rotation, (Object)input.rotation).append(this.pageSelection, input.pageSelection).isEquals();
    }
}

