/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.tools.merge;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.pdfsam.core.support.params.AbstractPdfOutputParametersBuilder;
import org.pdfsam.core.support.params.SingleOutputTaskParametersBuilder;
import org.pdfsam.eventstudio.annotation.EventListener;
import org.pdfsam.eventstudio.annotation.EventStation;
import org.pdfsam.i18n.I18nContext;
import org.pdfsam.model.tool.ClearToolRequest;
import org.pdfsam.tools.merge.MergeOptionsPane;
import org.pdfsam.tools.merge.MergeParametersBuilder;
import org.pdfsam.tools.merge.MergeSelectionPane;
import org.pdfsam.ui.components.io.BrowsablePdfOutputField;
import org.pdfsam.ui.components.io.PdfDestinationPane;
import org.pdfsam.ui.components.support.Views;
import org.pdfsam.ui.components.tool.BaseToolPanel;
import org.pdfsam.ui.components.tool.Footer;

public class MergeToolPanel
extends BaseToolPanel {
    private final MergeSelectionPane selectionPane = new MergeSelectionPane("merge");
    private final MergeOptionsPane mergeOptions = new MergeOptionsPane();
    private final BrowsablePdfOutputField destinationFileField;
    private final PdfDestinationPane destinationPane;

    @Inject
    public MergeToolPanel(@Named(value="mergefield") BrowsablePdfOutputField destinationFileField, @Named(value="mergepane") PdfDestinationPane destinationPane, @Named(value="mergefooter") Footer footer) {
        super("merge", footer);
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
        this.initModuleSettingsPanel(this.settingPanel());
    }

    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.mergeOptions.saveStateTo(data);
        this.destinationFileField.saveStateTo(data);
        this.destinationPane.saveStateTo(data);
    }

    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.mergeOptions.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom(data);
        this.destinationPane.restoreStateFrom(data);
    }

    protected MergeParametersBuilder getBuilder(Consumer<String> onError) {
        MergeParametersBuilder builder = new MergeParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.mergeOptions.apply(builder, onError);
        this.destinationFileField.apply((SingleOutputTaskParametersBuilder)builder, onError);
        this.destinationPane.apply((AbstractPdfOutputParametersBuilder)builder, onError);
        return builder;
    }

    private VBox settingPanel() {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane((String)I18nContext.i18n().tr("Merge settings"), (Node)this.mergeOptions), Views.titledPane((String)I18nContext.i18n().tr("Destination file"), (Node)this.destinationPane)});
        return pane;
    }

    @EventStation
    public String id() {
        return "merge";
    }

    @EventListener
    public void onClearModule(ClearToolRequest e) {
        if (e.clearEverything()) {
            this.mergeOptions.resetView();
            this.destinationPane.resetView();
        }
    }
}

