/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.validation.validator;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import org.sejda.model.pdf.page.PageRange;
import org.sejda.model.pdf.page.PageRangeSelection;
import org.sejda.model.validation.constraint.NoIntersections;

public class NoIntersectionsValidator
implements ConstraintValidator<NoIntersections, PageRangeSelection> {
    public boolean isValid(PageRangeSelection value, ConstraintValidatorContext context) {
        if (value != null) {
            ArrayList<PageRange> ranges = new ArrayList<PageRange>(value.getPageSelection());
            for (int i = 0; i < ranges.size(); ++i) {
                PageRange range = (PageRange)ranges.get(i);
                for (int j = i + 1; j < ranges.size(); ++j) {
                    PageRange current = (PageRange)ranges.get(j);
                    if (!range.intersects(current)) continue;
                    context.disableDefaultConstraintViolation();
                    context.buildConstraintViolationWithTemplate(String.format("Invalid page ranges, found an intersection between %s and %s", range, current)).addPropertyNode("page ranges").addConstraintViolation();
                    return false;
                }
            }
        }
        return true;
    }
}

